/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.lifecycle;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tests.api.pojos.DependencyInjectionObject;

@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Artifact Objects Dependency injection")
public class DependencyInjectionTestCase
extends AbstractIntegrationTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/lifecycle/artifact-object-dependency-injection-config.xml";
    }

    @Test
    public void validateInjectedObjectsDefinedInXmlConfig() {
        DependencyInjectionObject dependencyInjectionObject = (DependencyInjectionObject)this.registry.lookupByName("dependencyInjectionBean").get();
        this.validateInjectedObjects(dependencyInjectionObject);
    }

    @Test
    public void validateInjectedObjectsUsingInjector() throws MuleException {
        DependencyInjectionObject dependencyInjectionObject = new DependencyInjectionObject();
        muleContext.getInjector().inject((Object)dependencyInjectionObject);
        this.validateInjectedObjects(dependencyInjectionObject);
    }

    private void validateInjectedObjects(DependencyInjectionObject dependencyInjectionObject) {
        Assert.assertThat((Object)dependencyInjectionObject.getConfigurationComponentLocator(), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)dependencyInjectionObject.getExtensionsClient(), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)dependencyInjectionObject.getExpressionLanguage(), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)dependencyInjectionObject.getMuleExpressionLanguage(), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)dependencyInjectionObject.getTransformationService(), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)dependencyInjectionObject.getObjectSerializer(), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)dependencyInjectionObject.getServerNotificationHandler(), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)dependencyInjectionObject.getLocalObjectStoreManager(), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)dependencyInjectionObject.getObjectStoreManager(), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)dependencyInjectionObject.getObjectStoreManager().equals(dependencyInjectionObject.getLocalObjectStoreManager()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)dependencyInjectionObject.getLocalLockFactory(), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)dependencyInjectionObject.getLockFactory(), (Matcher)IsNull.notNullValue());
        Assert.assertThat((Object)dependencyInjectionObject.getLocalLockFactory().equals(dependencyInjectionObject.getLockFactory()), (Matcher)Is.is((Object)true));
    }
}

