/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.http.api.HttpService;
import org.mule.service.http.TestHttpClient;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

@Issue(value="MULE-18770")
@Feature(value="Correlation ID")
@Story(value="Sources' correlation id generation")
public class SourceCorrelationIdSourceGeneratedTestCase
extends AbstractIntegrationTestCase {
    private static final String TEST_CORRELATION_ID = "cheems";
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();

    protected String getConfigFile() {
        return "org/mule/test/config/correlation-id/source-generated.xml";
    }

    @Test
    public void execute() throws Exception {
        CoreEvent result = ((FlowRunner)this.flowRunner("execute").withSourceCorrelationId(TEST_CORRELATION_ID)).run();
        String correlationID = result.getMessage().getPayload().getValue().toString();
        MatcherAssert.assertThat((Object)correlationID, (Matcher)CoreMatchers.is((Object)TEST_CORRELATION_ID));
    }
}

