/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls.crl;

import io.qameta.allure.Feature;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateRevokedException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.Rule;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tls.fips.DefaultTestConfiguration;

@Feature(value="TLS/SSL")
public abstract class AbstractHttpTlsRevocationTestCase
extends AbstractIntegrationTestCase {
    private static final String UNDETERMINED_REVOCATION_ERROR_MESSAGE = "Could not determine revocation status";
    protected static final String EMPTY_CRL_FILE_PATH = "tls/crl/emptyCrl";
    protected static final String REVOKED_CRL_FILE_PATH = "tls/crl/validCrl";
    protected static final String OUTDATED_CRL_FILE_PATH = "tls/crl/outdatedCrl";
    protected static final String NO_CR_LS_FOUND_FOR_ISSUER_BC_ERROR_MESSGE = "No CRLs found for issuer";
    protected static final String KEY_COMPROMISE_BC_ERROR_MESSAGE = "keyCompromise";
    protected static final String ENTITY_CERTIFIED_NO_REVOCATION_SUB_PATH = "entity1";
    protected static final String ENTITY_CERTIFIED_OUTDATED_CRL_SUB_PATH = AbstractHttpTlsRevocationTestCase.getEntity2KeyStore();
    protected static final String ENTITY_CERTIFIED_REVOCATION_SUB_PATH = "entity3";
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public SystemProperty crlSystemProperty;
    @Rule
    public SystemProperty entityCertifiedSubPathSystemProperty;
    public String configFile;

    public AbstractHttpTlsRevocationTestCase(String configFile, String crlPath, String entityCertified) {
        this.configFile = configFile;
        this.crlSystemProperty = new SystemProperty("crlPath", crlPath);
        this.entityCertifiedSubPathSystemProperty = new SystemProperty("entityCertifiedSubPath", entityCertified);
    }

    public AbstractHttpTlsRevocationTestCase(String configFile, String entityCertified) {
        this.configFile = configFile;
        this.entityCertifiedSubPathSystemProperty = new SystemProperty("entityCertifiedSubPath", entityCertified);
    }

    protected String getConfigFile() {
        return this.configFile;
    }

    protected CoreEvent runRevocationTestFlow() throws Exception {
        return ((FlowRunner)this.flowRunner("testFlowRevoked").withPayload((Object)"data")).keepStreamsOpen().run();
    }

    protected void verifyUndeterminedRevocationException(Throwable e) {
        Throwable rootException = ExceptionUtils.getRootCause((Throwable)e);
        if (DefaultTestConfiguration.isFipsTesting()) {
            MatcherAssert.assertThat((Object)rootException.getMessage(), (Matcher)CoreMatchers.containsString((String)NO_CR_LS_FOUND_FOR_ISSUER_BC_ERROR_MESSGE));
        } else {
            MatcherAssert.assertThat((Object)rootException, (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(CertPathValidatorException.class)));
            MatcherAssert.assertThat((Object)rootException.getMessage(), (Matcher)Is.is((Object)UNDETERMINED_REVOCATION_ERROR_MESSAGE));
        }
    }

    protected void verifyRevocationException(Throwable e) {
        Throwable rootException = ExceptionUtils.getRootCause((Throwable)e);
        if (DefaultTestConfiguration.isFipsTesting()) {
            MatcherAssert.assertThat((Object)rootException.getMessage(), (Matcher)CoreMatchers.containsString((String)KEY_COMPROMISE_BC_ERROR_MESSAGE));
        } else {
            MatcherAssert.assertThat((Object)rootException, (Matcher)Is.is((Matcher)CoreMatchers.instanceOf(CertificateRevokedException.class)));
            MatcherAssert.assertThat((Object)((Object)((CertificateRevokedException)rootException).getRevocationReason()), (Matcher)Is.is((Object)((Object)CRLReason.KEY_COMPROMISE)));
        }
    }

    protected void verifyNotRevokedEntity() throws Exception {
        CoreEvent result = this.runRevocationTestFlow();
        MatcherAssert.assertThat((Object)result.getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)IsEqual.equalTo((Object)"OK")));
    }

    private static String getEntity2KeyStore() {
        if (DefaultTestConfiguration.isFipsTesting()) {
            return "entity2-fips";
        }
        return "entity2";
    }
}

