/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.streaming;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

public class LogStreamDataRepeatedlyTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");

    protected String getConfigFile() {
        return "org/mule/test/integration/streaming/log-repeatable-stream-config.xml";
    }

    @Test
    public void logsRepeatableStreamTwice() throws Exception {
        HttpPost httpPost = new HttpPost(String.format("http://localhost:%s/", this.listenPort.getNumber()));
        httpPost.setEntity((HttpEntity)new StringEntity("{\"name\": \"tato\", \"id\": \"42\"}", ContentType.APPLICATION_JSON));
        try (CloseableHttpClient client = HttpClients.createDefault();
             CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);){
            MatcherAssert.assertThat((Object)response.getStatusLine().getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
            MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)"OK"));
        }
    }
}

