/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.core.context.notification;

import org.junit.After;
import org.junit.Assert;
import org.mule.runtime.api.notification.AbstractServerNotification;
import org.mule.runtime.api.notification.IntegerAction;
import org.mule.runtime.api.notification.Notification;
import org.mule.tck.core.context.notification.NotificationLogger;
import org.mule.tck.probe.JUnitProbe;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.test.core.context.notification.RestrictedNode;

public abstract class AbstractNotificationTestCase
extends AbstractIntegrationTestCase {
    private NotificationLogger notificationLogger;

    @After
    public void clearNotifications() {
        if (this.notificationLogger != null) {
            this.notificationLogger.getNotifications().clear();
        }
    }

    public final void assertNotifications() throws Exception {
        this.notificationLogger = (NotificationLogger)this.registry.lookupByName("notificationLogger").get();
        muleContext.dispose();
        PollingProber prober = new PollingProber(30000L, 2000L);
        prober.check((Probe)new JUnitProbe(){

            protected boolean test() throws Exception {
                String notificationsLog = AbstractNotificationTestCase.this.buildLogNotifications();
                RestrictedNode spec = AbstractNotificationTestCase.this.getSpecification();
                AbstractNotificationTestCase.this.validateSpecification(spec);
                AbstractNotificationTestCase.this.assertExpectedNotifications(notificationsLog, spec);
                return true;
            }
        });
    }

    public abstract RestrictedNode getSpecification();

    public abstract void validateSpecification(RestrictedNode var1) throws Exception;

    protected String buildLogNotifications() {
        StringBuilder logMessageBuilder = new StringBuilder();
        logMessageBuilder.append("Number of notifications: " + this.notificationLogger.getNotifications().size() + System.lineSeparator());
        for (AbstractServerNotification notification : this.notificationLogger.getNotifications()) {
            logMessageBuilder.append("\t" + String.valueOf(notification) + System.lineSeparator());
        }
        return logMessageBuilder.toString();
    }

    protected void assertExpectedNotifications(String notificationsLog, RestrictedNode spec) {
        int i = 0;
        for (AbstractServerNotification notification : this.notificationLogger.getNotifications()) {
            ++i;
            int match = spec.match(notification);
            switch (match) {
                case 0: {
                    break;
                }
                case 1: {
                    Assert.fail((String)("Could not match " + String.valueOf(notification) + System.lineSeparator() + notificationsLog));
                    break;
                }
                case 2: {
                    Assert.fail((String)("Extra notification: " + String.valueOf(notification) + System.lineSeparator() + notificationsLog));
                }
            }
        }
        if (!spec.isExhausted()) {
            Assert.fail((String)("Specification not exhausted: " + String.valueOf(spec.getAnyRemaining()) + System.lineSeparator() + notificationsLog));
        }
    }

    protected void verifyAllNotifications(RestrictedNode spec, Class<?> clazz, int from, int to) {
        for (int action = from; action <= to; ++action) {
            if (spec.contains(clazz, (Notification.Action)new IntegerAction(action))) continue;
            Assert.fail((String)("Specification missed action " + action + " for class " + String.valueOf(clazz)));
        }
    }

    protected void verifyNotification(RestrictedNode spec, Class<?> clazz, Notification.Action action) {
        if (!spec.contains(clazz, action)) {
            Assert.fail((String)("Specification missed action " + String.valueOf(action) + " for class " + String.valueOf(clazz)));
        }
    }
}

