/*
 * Decompiled with CFR 0.152.
 */
package org.mule.shutdown;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.AbstractIntegrationTestCase;

public abstract class AbstractShutdownTimeoutRequestResponseTestCase
extends AbstractIntegrationTestCase {
    protected static Latch waitLatch;
    protected static Latch contextStopLatch;
    protected ExecutorService executor;
    @Rule
    public DynamicPort httpPort = new DynamicPort("httpPort");

    @Before
    public void before() {
        this.executor = Executors.newSingleThreadExecutor();
    }

    @After
    public void after() {
        this.executor.shutdownNow();
    }

    @Before
    public void setUpWaitLatch() throws Exception {
        waitLatch = new Latch();
        contextStopLatch = new Latch();
    }

    public static class NoBlockMessageProcessor
    extends AbstractComponent
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            waitLatch.release();
            return event;
        }
    }

    public static class BlockMessageProcessor
    extends AbstractComponent
    implements Processor {
        public CoreEvent process(CoreEvent event) throws MuleException {
            waitLatch.release();
            try {
                contextStopLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new DefaultMuleException((Throwable)e);
            }
            return event;
        }
    }
}

