/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls.crl.client;

import io.qameta.allure.Feature;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.functional.junit4.AbstractConfigurationFailuresTestCase;
import org.mule.runtime.api.lifecycle.CreateException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.tls.fips.DefaultTestConfiguration;

@Feature(value="TLS/SSL")
public class HttpInvalidCrlAlgorithmTestCase
extends AbstractConfigurationFailuresTestCase {
    public static final String INVALID_CRL_ALGORITHM_SunX509 = "TLS Context: certificate revocation checking is only available for algorithm PKIX (current value is SunX509)";

    @BeforeClass
    public static void before() {
        Assume.assumeFalse((String)"W-16968647: Check that this is not in fips where the standard revocation check does not work. Another of the documented options should be used", (boolean)DefaultTestConfiguration.isFipsTesting());
    }

    @Test
    public void testInvalidCrlAlgorithm() {
        Exception exception = (Exception)Assert.assertThrows(Exception.class, () -> this.loadConfiguration("http-requester-tls-crl-invalid-algorithm-config.xml"));
        Throwable rootCause = ExceptionUtils.getRootCause((Throwable)exception);
        MatcherAssert.assertThat((Object)rootCause, (Matcher)CoreMatchers.instanceOf(CreateException.class));
        MatcherAssert.assertThat((Object)rootCause.getMessage(), (Matcher)Is.is((Object)INVALID_CRL_ALGORITHM_SunX509));
    }

    protected List<ExtensionModel> getRequiredExtensions() {
        ExtensionModel mule = MuleExtensionModelProvider.getExtensionModel();
        ExtensionModel tls = MuleExtensionModelProvider.getTlsExtensionModel();
        return Arrays.asList(mule, tls);
    }
}

