/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls;

import io.qameta.allure.Feature;
import java.io.File;
import java.io.PrintWriter;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tls.fips.DefaultTestConfiguration;

@Feature(value="TLS/SSL")
public class HttpListenerTlsRestrictedProtocolsAndCiphersTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public DynamicPort httpsPort = new DynamicPort("port");
    private static final String SERVER_CIPHER_SUITE_ENABLED = "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256";
    private static final String SERVER_CIPHER_SUITE_DISABLED = "TLS_DHE_RSA_WITH_AES_128_CBC_SHA";
    private static final String SERVER_PROTOCOL_ENABLED = "TLSv1.2";
    private static final String SERVER_PROTOCOL_DISABLED = "TLSv1";
    @Rule
    public SystemProperty serverKeyStoreFile = new SystemProperty("serverKeyStoreFile", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestServerKeyStore());
    @Rule
    public SystemProperty serverKeyStoreType = new SystemProperty("serverKeyStoreType", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestStoreType());

    @BeforeClass
    public static void createTlsPropertiesFile() throws Exception {
        PrintWriter writer = new PrintWriter(HttpListenerTlsRestrictedProtocolsAndCiphersTestCase.getTlsPropertiesFile(), "UTF-8");
        writer.println("enabledCipherSuites=TLS_DHE_RSA_WITH_AES_128_CBC_SHA256");
        writer.println("enabledProtocols=TLSv1.2");
        writer.close();
    }

    @AfterClass
    public static void removeTlsPropertiesFile() {
        HttpListenerTlsRestrictedProtocolsAndCiphersTestCase.getTlsPropertiesFile().delete();
    }

    private static File getTlsPropertiesFile() {
        return new File("tls-default.conf");
    }

    protected String getConfigFile() {
        return "http-listener-tls-restricted-protocols-ciphers-config.xml";
    }

    @Test
    public void handshakeSuccessWhenUsingEnabledCipherSpec() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        SSLSocket socket = this.createSocket(new String[]{SERVER_CIPHER_SUITE_ENABLED, SERVER_CIPHER_SUITE_DISABLED}, new String[]{SERVER_PROTOCOL_ENABLED, SERVER_PROTOCOL_DISABLED});
        socket.addHandshakeCompletedListener(handshakeCompletedEvent -> latch.countDown());
        socket.startHandshake();
        MatcherAssert.assertThat((Object)latch.await(30000L, TimeUnit.MILLISECONDS), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)SERVER_CIPHER_SUITE_ENABLED, (Matcher)Matchers.is((Object)socket.getSession().getCipherSuite()));
        MatcherAssert.assertThat((Object)SERVER_PROTOCOL_ENABLED, (Matcher)Matchers.is((Object)socket.getSession().getProtocol()));
        socket.close();
    }

    @Test
    public void handshakeFailureWithDisabledCipherSuite() throws Exception {
        SSLSocket socket = this.createSocket(new String[]{SERVER_CIPHER_SUITE_DISABLED}, new String[]{SERVER_PROTOCOL_ENABLED});
        Assert.assertThrows(Exception.class, socket::startHandshake);
    }

    @Test
    public void handshakeFailureWithDisabledProtocol() throws Exception {
        SSLSocket socket = this.createSocket(new String[]{SERVER_CIPHER_SUITE_ENABLED}, new String[]{SERVER_PROTOCOL_DISABLED});
        Assert.assertThrows(Exception.class, socket::startHandshake);
    }

    private SSLSocket createSocket(String[] cipherSuites, String[] enabledProtocols) throws Exception {
        TlsContextFactory tlsContextFactory = TlsContextFactory.builder().trustStorePath(DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestGenericTrustKeyStore()).trustStoreType(DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestStoreType()).trustStorePassword("mulepassword").build();
        SSLContext sslContext = tlsContextFactory.createSslContext();
        SSLSocketFactory socketFactory = sslContext.getSocketFactory();
        SSLSocket socket = (SSLSocket)socketFactory.createSocket("localhost", this.httpsPort.getNumber());
        socket.setEnabledCipherSuites(cipherSuites);
        socket.setEnabledProtocols(enabledProtocols);
        return socket;
    }
}

