/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.connection;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.interception.InterceptionAction;
import org.mule.runtime.api.interception.InterceptionEvent;
import org.mule.runtime.api.interception.ProcessorInterceptor;
import org.mule.runtime.api.interception.ProcessorInterceptorFactory;
import org.mule.runtime.api.interception.ProcessorParameterValue;
import org.mule.tck.junit4.matcher.ErrorTypeMatcher;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Deployment Configuration")
@Story(value="Lazy Connections")
public class LazyConnectionsTestCase
extends AbstractIntegrationTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/connection/lazy-connections-config.xml";
    }

    @Test
    public void executedOperationThrowsConnectivityError() throws Exception {
        this.testPetStoreFlow("skipOperationFlowInvalidConfig");
        this.testPetStoreFlow("skipOperationFlowInvalidConfigFailsDeployment");
    }

    @Test
    public void executeDbOperation() throws Exception {
        this.testDbFlow("dbOperationFlow");
    }

    private void testPetStoreFlow(String flowName) throws Exception {
        ((FlowRunner)this.flowRunner(flowName).withVariable("execute", (Object)true)).runExpectingException(ErrorTypeMatcher.errorType((String)"PETSTORE", (String)"CONNECTIVITY"));
    }

    private void testDbFlow(String flowName) throws Exception {
        ((FlowRunner)this.flowRunner(flowName).withVariable("execute", (Object)true)).run();
    }

    protected Optional<Properties> getDeploymentProperties() {
        Properties properties = new Properties();
        properties.put("mule.application.deployment.lazyConnections", "true");
        return Optional.of(properties);
    }

    protected boolean isGracefulShutdown() {
        return true;
    }

    public static class TestInterceptorFactory
    implements ProcessorInterceptorFactory {
        public ProcessorInterceptor get() {
            return new ProcessorInterceptor(){

                public CompletableFuture<InterceptionEvent> around(ComponentLocation location, Map<String, ProcessorParameterValue> parameters, InterceptionEvent event, InterceptionAction action) {
                    if (location.getComponentIdentifier().getIdentifier().getNamespace().equalsIgnoreCase("db")) {
                        return action.skip();
                    }
                    return action.proceed();
                }
            };
        }
    }
}

