/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tls;

import io.qameta.allure.Feature;
import java.io.InputStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.jupiter.api.DisplayName;
import org.mule.extension.http.api.error.HttpRequestFailedException;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.tls.TlsContextFactoryBuilder;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.entity.ByteArrayHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.AbstractIntegrationTestCase;
import org.mule.tls.TlsTestUtils;
import org.mule.tls.fips.DefaultTestConfiguration;

@Feature(value="TLS/SSL")
@DisplayName(value="HTTPS Restricted Ciphers and Protocols")
public class HttpRestrictedCiphersAndProtocolsTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");
    @Rule
    public DynamicPort port2 = new DynamicPort("port2");
    @Rule
    public DynamicPort port3 = new DynamicPort("port3");
    @Rule
    public SystemProperty cipherSuites = new SystemProperty("cipherSuites", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA");
    @Rule
    public SystemProperty protocol = new SystemProperty("protocol", "HTTPS");
    @Rule
    public ExpectedError expectedError = ExpectedError.none();
    @Rule
    public SystemProperty trustStoreFile = new SystemProperty("trustStore", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestGenericTrustKeyStore());
    @Rule
    public SystemProperty storeType = new SystemProperty("storeType", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestStoreType());
    @Rule
    public SystemProperty serverKeyStore = new SystemProperty("serverKeyStore", DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestServerKeyStore());
    public HttpClient httpClientWithCertificate;
    private TlsContextFactory tlsContextFactory;
    private final TlsContextFactoryBuilder tlsContextFactoryBuilder = TlsContextFactory.builder();

    protected String getConfigFile() {
        return "http-restricted-ciphers-and-protocols-config.xml";
    }

    @Before
    public void setUp() {
        this.tlsContextFactoryBuilder.trustStorePath(DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestGenericTrustKeyStore());
        this.tlsContextFactoryBuilder.trustStorePassword("mulepassword");
        this.tlsContextFactoryBuilder.trustStoreType(DefaultTestConfiguration.getDefaultEnvironmentConfiguration().getTestStoreType());
    }

    @After
    public void after() {
        if (this.httpClientWithCertificate != null) {
            this.httpClientWithCertificate.stop();
        }
    }

    @Test
    public void worksWithProtocolAndCipherSuiteMatch() throws Exception {
        CoreEvent response = ((FlowRunner)this.flowRunner("12Client12Server").withPayload((Object)"test")).run();
        MatcherAssert.assertThat((Object)response.getMessage().getPayload().getValue(), (Matcher)Matchers.is((Object)"test"));
    }

    @Test
    @Ignore(value="Failing because of JDK defaults")
    public void worksWithProtocolMatch() throws Exception {
        this.tlsContextFactory = this.tlsContextFactoryBuilder.build();
        this.createHttpClient();
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("https://localhost:%s", this.port1.getValue())).method(HttpConstants.Method.POST).entity((HttpEntity)new ByteArrayHttpEntity("test".getBytes()))).build();
        HttpResponse response = this.httpClientWithCertificate.send(request, 5000, false, null);
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.is((Object)"test"));
    }

    @Test
    public void worksWithCipherSuiteMatch() throws Exception {
        this.tlsContextFactoryBuilder.enabledCipherSuites(this.cipherSuites.getValue());
        this.tlsContextFactory = this.tlsContextFactoryBuilder.build();
        this.createHttpClient();
        HttpRequest request = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("https://localhost:%s", this.port3.getValue())).method(HttpConstants.Method.POST).entity((HttpEntity)new ByteArrayHttpEntity("test".getBytes()))).build();
        HttpResponse response = this.httpClientWithCertificate.send(request, 5000, false, null);
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent()), (Matcher)Matchers.is((Object)"test"));
    }

    public void createHttpClient() {
        this.httpClientWithCertificate = ((HttpService)this.getService(HttpService.class)).getClientFactory().create(new HttpClientConfiguration.Builder().setName(this.getClass().getSimpleName()).setTlsContextFactory(this.tlsContextFactory).build());
        this.httpClientWithCertificate.start();
    }

    @Test
    public void failsWithProtocolMismatch() throws Exception {
        this.expectedError.expectCause(Matchers.instanceOf(HttpRequestFailedException.class));
        this.expectedError.expectMessage((Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)"Remotely closed"), TlsTestUtils.sslValidationError()));
        ((FlowRunner)this.flowRunner("12Client1Server").withPayload((Object)"test")).run();
    }

    @Test
    public void failsWithCipherSuiteMismatch() throws Exception {
        this.expectedError.expectCause(Matchers.instanceOf(HttpRequestFailedException.class));
        this.expectedError.expectMessage((Matcher)Matchers.anyOf((Matcher)Matchers.containsString((String)"Remotely closed"), TlsTestUtils.sslValidationError()));
        ((FlowRunner)this.flowRunner("12CipherClient1CipherServer").withPayload((Object)"test")).run();
    }
}

