/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.exceptions;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.exception.ExpectedError;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.functional.junit4.matchers.MessageMatchers;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.security.UnauthorisedException;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.tck.junit4.matcher.EventMatcher;
import org.mule.test.AbstractIntegrationTestCase;

@Feature(value="Error Handling")
@Story(value="Error Handling Reuse")
public class ErrorHandlingReuseTestCase
extends AbstractIntegrationTestCase {
    @Rule
    public ExpectedError expectedError = ExpectedError.none();

    protected String getConfigFile() {
        return "org/mule/test/integration/exceptions/error-handling-reuse-config.xml";
    }

    @Test
    public void usesReferencedErrorHandler() throws Exception {
        this.verifyFlowWhenThrowing("withSharedHandler", (Exception)new UnauthorisedException(I18nMessageFactory.createStaticMessage((String)"Can't touch this!")), " security");
    }

    @Test
    public void usesReferencedErrorHandlerWithGeneralOnErrorPropagateReference() throws Exception {
        this.expectedError.expectErrorType("MULE", "UNKNOWN");
        this.expectedError.expectEvent((Matcher)EventMatcher.hasMessage((Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)"test any shared"))));
        ((FlowRunner)((FlowRunner)this.flowRunner("withSharedHandler").withPayload((Object)"test")).withVariable("exception", (Object)new IndexOutOfBoundsException())).run();
    }

    @Test
    public void usesReferencedErrorHandlerWithMidOnErrorContinueReference() throws Exception {
        this.verifyFlowWhenThrowing("withSharedHandler", (Exception)new ExpressionRuntimeException(I18nMessageFactory.createStaticMessage((String)"Failed")), " expression");
    }

    @Test
    public void usesReferencedOnError() throws Exception {
        this.verifyFlowWhenThrowing("withSharedHandlersInline", (Exception)new ExpressionRuntimeException(I18nMessageFactory.createStaticMessage((String)"Failed")), " expression");
    }

    @Test
    public void goesThroughReferencedOnError() throws Exception {
        this.verifyFlowWhenThrowing("withSharedHandlersInline", (Exception)new ConnectionException("Wrong turn"), " connectivity");
    }

    @Test
    public void usesReferencedErrorHandlerInTry() throws Exception {
        this.verifyFlowWhenThrowing("withTryAndSharedHandler", (Exception)new ConnectionException("Wrong turn"), " hey connectivity");
    }

    @Test
    public void usesReferencedOnErrorInTry() throws Exception {
        this.verifyFlowWhenThrowing("withTryAndSharedHandlersInline", (Exception)new ExpressionRuntimeException(I18nMessageFactory.createStaticMessage((String)"Oh, man!")), " hey expression");
    }

    private void verifyFlowWhenThrowing(String flowName, Exception exception, String expectedAppend) throws Exception {
        MatcherAssert.assertThat((Object)((FlowRunner)((FlowRunner)this.flowRunner(flowName).withPayload((Object)"test")).withVariable("exception", (Object)exception)).run().getMessage(), (Matcher)MessageMatchers.hasPayload((Matcher)Matchers.equalTo((Object)("test" + expectedAppend))));
    }
}

