/*
 * Decompiled with CFR 0.152.
 */
package org.mule.util.store;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.store.ObjectStore;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.store.MuleObjectStoreManager;
import org.mule.util.store.SimpleMemoryObjectStore;

public class MuleObjectStoreDisposalTestCase
extends FunctionalTestCase {
    private static final String TEST_OS_NAME = "disposalTest";
    private static final int MAX_ENTRIES = 100;
    private static final int TIMEOUT = 9999;
    private static final String DISPOSABLE_TRANSIENT_USER_STORE_KEY = "DISPOSABLE_TRANSIENT_USER_STORE_KEY";
    private MuleObjectStoreManager osm;

    protected String getConfigResources() {
        return "mule-config.xml";
    }

    protected void doSetUp() throws Exception {
        this.osm = (MuleObjectStoreManager)muleContext.getRegistry().lookupObject("_muleObjectStoreManager");
        muleContext.getRegistry().registerObject(DISPOSABLE_TRANSIENT_USER_STORE_KEY, (Object)new SimpleMemoryObjectStore());
        this.osm.setBaseTransientUserStoreKey(DISPOSABLE_TRANSIENT_USER_STORE_KEY);
    }

    @Test
    public void shutdownScheduler() throws Exception {
        this.osm.scheduler = (ScheduledThreadPoolExecutor)Mockito.spy((Object)this.osm.scheduler);
        this.doDispose();
        ((ScheduledThreadPoolExecutor)Mockito.verify((Object)this.osm.scheduler)).shutdown();
    }

    @Test
    public void disposeMonitoredObjectStores() throws Exception {
        this.osm.getUserObjectStore(TEST_OS_NAME, false, 100, 9999, 9999);
        ObjectStore managedObjectStore = (ObjectStore)this.osm.stores.get(TEST_OS_NAME);
        junit.framework.Assert.assertNotNull((Object)managedObjectStore);
        Assert.assertTrue((boolean)(managedObjectStore instanceof Disposable));
        managedObjectStore = (ObjectStore)Mockito.spy((Object)managedObjectStore);
        this.osm.stores.put(TEST_OS_NAME, managedObjectStore);
        this.doDispose();
        ((Disposable)Mockito.verify((Object)((Disposable)managedObjectStore))).dispose();
    }

    private void doDispose() {
        muleContext.dispose();
        muleContext = null;
    }
}

