/*
 * Decompiled with CFR 0.152.
 */
package org.mule.transformers.simple;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.api.lifecycle.Callable;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.junit4.FunctionalTestCase;

public class SessionVariableAfterMuleClientTestCase
extends FunctionalTestCase {
    private static final String SESSION_VARIABLE_VALUE = "TEST";
    private static String inboundSessionVariableValue;
    private static String outboundSessionVariableValue;

    protected String getConfigFile() {
        return "session-variable-after-mule-client.xml";
    }

    @Before
    public void setUp() throws Exception {
        inboundSessionVariableValue = null;
        outboundSessionVariableValue = null;
    }

    @Test
    public void testSessionVariableExistsAfterDispatch() throws Exception {
        this.runFlow("flow-dispatcher");
        Assert.assertThat((Object)inboundSessionVariableValue, (Matcher)CoreMatchers.is((Object)SESSION_VARIABLE_VALUE));
        Assert.assertThat((Object)outboundSessionVariableValue, (Matcher)CoreMatchers.is((Object)SESSION_VARIABLE_VALUE));
    }

    @Test
    public void testSessionVariableExistsAfterSend() throws Exception {
        this.runFlow("flow-sender");
        Assert.assertThat((Object)inboundSessionVariableValue, (Matcher)CoreMatchers.is((Object)SESSION_VARIABLE_VALUE));
        Assert.assertThat((Object)outboundSessionVariableValue, (Matcher)CoreMatchers.is((Object)SESSION_VARIABLE_VALUE));
    }

    public static class OutboundJavaComponent
    implements Callable {
        public Object onCall(MuleEventContext eventContext) throws Exception {
            outboundSessionVariableValue = (String)eventContext.getMessage().getProperty("testVariable", PropertyScope.SESSION);
            return eventContext.getMessage().getPayload();
        }
    }

    public static class SendJavaComponent
    implements Callable {
        public Object onCall(MuleEventContext eventContext) throws Exception {
            inboundSessionVariableValue = (String)eventContext.getMessage().getProperty("testVariable", PropertyScope.SESSION);
            eventContext.getMuleContext().getClient().send("vm://in", eventContext.getMessage());
            return eventContext.getMessage().getPayload();
        }
    }

    public static class DispatchJavaComponent
    implements Callable {
        public Object onCall(MuleEventContext eventContext) throws Exception {
            inboundSessionVariableValue = (String)eventContext.getMessage().getProperty("testVariable", PropertyScope.SESSION);
            eventContext.getMuleContext().getClient().dispatch("vm://in", eventContext.getMessage());
            return eventContext.getMessage().getPayload();
        }
    }
}

