/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.usecases.sync;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.transformer.compression.GZipUncompressTransformer;
import org.mule.transformer.simple.ByteArrayToSerializable;
import org.mule.transformer.types.DataTypeFactory;

public class HttpTransformTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort httpPort1 = new DynamicPort("port1");
    @Rule
    public DynamicPort httpPort2 = new DynamicPort("port2");

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/usecases/sync/http-transform-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/usecases/sync/http-transform-flow.xml"});
    }

    public HttpTransformTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testTransform() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send(String.format("http://localhost:%d/RemoteService", this.httpPort1.getNumber()), HttpTransformTestCase.getTestMuleMessage((Object)"payload"));
        Assert.assertNotNull((Object)message);
        GZipUncompressTransformer gu = new GZipUncompressTransformer();
        gu.setMuleContext(muleContext);
        gu.setReturnDataType(DataTypeFactory.STRING);
        Assert.assertNotNull((Object)message.getPayload());
        String result = (String)gu.transform((Object)message.getPayloadAsBytes());
        Assert.assertEquals((Object)"<string>payload</string>", (Object)result);
    }

    @Test
    public void testBinary() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        ArrayList<Integer> payload = new ArrayList<Integer>();
        payload.add(42);
        MuleMessage message = client.send(String.format("http://localhost:%d/RemoteService", this.httpPort2.getNumber()), (Object)muleContext.getObjectSerializer().serialize(payload), null);
        Assert.assertNotNull((Object)message);
        ByteArrayToSerializable bas = new ByteArrayToSerializable();
        bas.setMuleContext(muleContext);
        Assert.assertNotNull((Object)message.getPayload());
        Object result = bas.transform(message.getPayload());
        Assert.assertEquals(payload, (Object)result);
    }

    @Test
    public void testBinaryWithBridge() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        List<Integer> payload = Arrays.asList(42);
        MuleMessage message = client.send("vm://LocalService", HttpTransformTestCase.getTestMuleMessage(payload));
        Assert.assertNotNull((Object)message);
        ByteArrayToSerializable bas = new ByteArrayToSerializable();
        bas.setMuleContext(muleContext);
        Assert.assertNotNull((Object)message.getPayload());
        Object result = bas.transform(message.getPayload());
        Assert.assertEquals(payload, (Object)result);
    }
}

