/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.usecases.sync;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class HttpJmsBridgeTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort httpPort = new DynamicPort("port");

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/usecases/sync/http-jms-bridge-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/usecases/sync/http-jms-bridge-flow.xml"});
    }

    public HttpJmsBridgeTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testBridge() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        String payload = "payload";
        HashMap<String, String> headers = new HashMap<String, String>();
        String customHeader = "X-Custom-Header";
        headers.put("X-Custom-Header", "value");
        client.dispatch(String.format("http://localhost:%d/in", this.httpPort.getNumber()), (MuleMessage)new DefaultMuleMessage((Object)payload, headers, muleContext), (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).build());
        MuleMessage msg = client.request("vm://out", 10000L);
        Assert.assertNotNull((Object)msg);
        Assert.assertEquals((Object)payload, (Object)msg.getPayloadAsString());
        Assert.assertEquals((Object)"value", (Object)msg.getInboundProperty("X-Custom-Header"));
    }
}

