/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.usecases.routing.response;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.IsNull;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.MuleClient;
import org.mule.test.usecases.routing.response.RequestReplyInForEachTestCase;

public class VMRequestReplyInForEachTestCase
extends RequestReplyInForEachTestCase {
    private ImmutableList<ImmutableList<String>> collectionValues;

    protected String getConfigFile() {
        return "org/mule/test/usecases/routing/response/vm-request-reply-in-for-each.xml";
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        ImmutableList nestedListA = ImmutableList.builder().add((Object)"value1").add((Object)"value2").add((Object)"value3").build();
        ImmutableList nestedListB = ImmutableList.builder().add((Object)"value4").add((Object)"value5").build();
        this.collectionValues = ImmutableList.builder().add((Object)nestedListA).add((Object)nestedListB).build();
    }

    @Test
    public void testRequestReplyWithNestedForEachWithSplitAggregate() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        DefaultMuleMessage message = new DefaultMuleMessage(this.collectionValues, (Map)Mockito.mock(Map.class), muleContext);
        client.dispatch("vm://foreach-spag", (MuleMessage)message);
        for (List sublist : this.collectionValues) {
            this.assertResultCollection((MuleClient)client, sublist, "-processed", "test-foreach-spag-reply");
        }
    }

    @Test
    public void testRequestReplyWithNestedForEachWithSplitAggregateAndNoCollectionExpression() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        DefaultMuleMessage message = new DefaultMuleMessage(this.collectionValues, (Map)Mockito.mock(Map.class), muleContext);
        client.dispatch("vm://foreach-no-expression-spag", (MuleMessage)message);
        for (List sublist : this.collectionValues) {
            this.assertResultCollection((MuleClient)client, sublist, "", "test-foreach-no-expression-spag-reply");
        }
    }

    private void assertResultCollection(MuleClient client, List<String> payload, String suffix, String queueName) throws Exception {
        MuleMessage reply = client.request("vm://" + queueName, 5000L);
        MatcherAssert.assertThat((Object)reply, (Matcher)Matchers.is((Matcher)IsNull.notNullValue()));
        List result = (List)reply.getPayload();
        MatcherAssert.assertThat((Object)result, (Matcher)IsCollectionWithSize.hasSize((int)payload.size()));
        for (String value : payload) {
            MatcherAssert.assertThat((Object)result, (Matcher)Matchers.hasItem((Object)(value + suffix)));
        }
    }
}

