/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.usecases.routing.response;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.OperationOptions;
import org.mule.api.serialization.ObjectSerializer;
import org.mule.api.store.ObjectStoreException;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.store.SimpleMemoryObjectStore;

public class SerializationOnResposeAggregatorTestCase
extends FunctionalTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    protected String getConfigFile() {
        return "org/mule/test/usecases/routing/response/serialization-on-response-router-config.xml";
    }

    @Test
    public void testSyncResponse() throws Exception {
        muleContext.getRegistry().registerObject("_defaultInMemoryObjectStore", (Object)new TestObjectStore(muleContext));
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("http://localhost:" + this.dynamicPort.getNumber(), SerializationOnResposeAggregatorTestCase.getTestMuleMessage((Object)"request"), (OperationOptions)HttpRequestOptionsBuilder.newOptions().method(HttpConstants.Methods.POST.name()).build());
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)"request processed", (Object)new String(message.getPayloadAsBytes()));
    }

    private static class TestObjectStore
    extends SimpleMemoryObjectStore<Serializable> {
        private ObjectSerializer serializer;

        private TestObjectStore(MuleContext muleContext) {
            this.serializer = muleContext.getObjectSerializer();
        }

        protected void doStore(Serializable key, Serializable value) throws ObjectStoreException {
            byte[] serialized = this.serializer.serialize((Object)value);
            super.doStore(key, (Serializable)serialized);
        }

        protected Serializable doRetrieve(Serializable key) {
            Serializable serialized = super.doRetrieve(key);
            return (Serializable)this.serializer.deserialize((byte[])serialized);
        }
    }
}

