/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.usecases.routing.response;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.client.MuleClient;
import org.mule.tck.junit4.FunctionalTestCase;

public abstract class RequestReplyInForEachTestCase
extends FunctionalTestCase {
    protected static final int TIMEOUT = 5000;
    private final List<String> values = new ArrayList<String>();

    @Before
    public void setUp() throws Exception {
        this.values.add("value1");
        this.values.add("value2");
        this.values.add("value3");
    }

    @Test
    public void testRequestReplyWithForEach() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        DefaultMuleMessage message = new DefaultMuleMessage(this.values, (Map)Mockito.mock(Map.class), muleContext);
        client.dispatch("vm://foreach", (MuleMessage)message);
        for (String value : this.values) {
            this.assertResult((MuleClient)client, value + "-processed", "test-foreach-reply");
        }
    }

    @Test
    public void testRequestReplyInSequenceCall() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"test", (Map)Mockito.mock(Map.class), muleContext);
        client.dispatch("vm://sequence-call", (MuleMessage)message);
        this.assertResult((MuleClient)client, "first-call-processed", "test-sequence-reply");
        this.assertResult((MuleClient)client, "second-call-processed", "test-sequence-reply");
    }

    private void assertResult(MuleClient client, String payload, String queueName) throws Exception {
        MuleMessage reply = client.request("vm://" + queueName, 5000L);
        Assert.assertThat((Object)reply, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)reply.getPayloadAsString(), (Matcher)CoreMatchers.is((Object)payload));
    }
}

