/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.usecases.http;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.transport.NullPayload;

public class HttpResponseTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/usecases/http/http-response-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/usecases/http/http-response-flow.xml"});
    }

    public HttpResponseTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testNullPayloadUsingAsync() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage reply = client.send("http://localhost:8990", (MuleMessage)new DefaultMuleMessage((Object)"test", muleContext));
        Assert.assertNotNull((Object)reply.getPayload());
        int status = (Integer)reply.getInboundProperty("http.status", (Object)0);
        Assert.assertEquals((long)status, (long)200L);
        Assert.assertEquals((long)0L, (long)reply.getPayloadAsString().length());
    }

    @Test
    public void testPayloadIsNotEmptyNoRemoteSynch() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage reply = client.send("http://localhost:8999", (MuleMessage)new DefaultMuleMessage((Object)"test", muleContext));
        Assert.assertNotNull((Object)reply.getPayload());
        Assert.assertFalse((boolean)(reply.getPayload() instanceof NullPayload));
        Assert.assertEquals((Object)"test", (Object)reply.getPayloadAsString());
    }

    @Test
    public void testPayloadIsNotEmptyWithRemoteSynch() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage reply = client.send("http://localhost:8989", (MuleMessage)new DefaultMuleMessage((Object)"test", muleContext));
        Assert.assertNotNull((Object)reply.getPayload());
        Assert.assertFalse((boolean)(reply.getPayload() instanceof NullPayload));
        Assert.assertEquals((Object)"test", (Object)reply.getPayloadAsString());
    }

    @Test
    public void testChunkingContentLength() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage reply = client.send("http://localhost:8988", (MuleMessage)new DefaultMuleMessage((Object)"test", muleContext));
        Assert.assertNotNull((Object)reply.getPayload());
        Assert.assertFalse((boolean)(reply.getPayload() instanceof NullPayload));
        Assert.assertEquals((Object)"chunked", (Object)reply.getInboundProperty("Transfer-Encoding"));
        Assert.assertNull((Object)reply.getInboundProperty("Content-Length"));
    }

    @Test
    public void testNoChunkingContentLength() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage reply = client.send("http://localhost:8987", (MuleMessage)new DefaultMuleMessage((Object)"test", muleContext));
        Assert.assertNotNull((Object)reply.getPayload());
        Assert.assertFalse((boolean)(reply.getPayload() instanceof NullPayload));
        Assert.assertNotSame((Object)"chunked", (Object)reply.getInboundProperty("Transfer-Encoding"));
        Assert.assertNotNull((Object)reply.getInboundProperty("Content-Length"));
    }
}

