/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.transformers;

import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleMessage;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.Base64;

public class TransformerEncodingTestCase
extends FunctionalTestCase {
    private static final String UTF_16_LE = "UTF-16LE";
    private static final String PAYLOAD = "This a string with swedish characters - \u00e4 \u00d6 \u00e5";

    protected String getConfigFile() {
        return "org/mule/test/transformers/transformer-encoding-config.xml";
    }

    @Test
    public void encodingFromTransformer() throws Exception {
        MuleMessage message = this.getMuleMessage();
        this.testEncoding("vm://base64decode", message);
    }

    @Test
    public void encodingFromSetProperty() throws Exception {
        MuleMessage message = this.getMuleMessage();
        this.testEncoding("vm://base64decode2", message);
    }

    @Test
    public void encodingFromMessage() throws Exception {
        MuleMessage message = this.getMuleMessage();
        message.setOutboundProperty("MULE_ENCODING", (Object)UTF_16_LE);
        this.testEncoding("vm://base64decode", message);
    }

    private void testEncoding(String endpointUrl, MuleMessage message) throws Exception {
        MuleMessage response = muleContext.getClient().send(endpointUrl, message);
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Matchers.is((Object)PAYLOAD));
    }

    private MuleMessage getMuleMessage() throws IOException {
        return new DefaultMuleMessage((Object)Base64.encodeBytes((byte[])PAYLOAD.getBytes(UTF_16_LE)), muleContext);
    }
}

