/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.transformers;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.IOUtils;
import org.mule.util.compression.GZipCompression;

public class GZipTransformerFunctionalTestCase
extends FunctionalTestCase {
    private static final String TEST_DATA = "the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog the quick brown fox jumped over the lazy dog";

    protected String getConfigFile() {
        return "org/mule/test/transformers/gzip-transformer-functional-test.xml";
    }

    @Test
    public void testCompressDecompressByteArray() throws Exception {
        byte[] testDataByteArray = TEST_DATA.getBytes();
        LocalMuleClient client = muleContext.getClient();
        MuleMessage compressedResponse = client.send("vm://compressInput", (Object)testDataByteArray, null);
        Assert.assertNotNull((Object)compressedResponse);
        Assert.assertTrue((boolean)(compressedResponse.getPayload() instanceof byte[]));
        MuleMessage uncompressedResponse = client.send("vm://decompressInput", compressedResponse.getPayload(), null);
        Assert.assertNotNull((Object)uncompressedResponse);
        Assert.assertTrue((boolean)(uncompressedResponse.getPayload() instanceof byte[]));
        String uncompressedStr = new String((byte[])uncompressedResponse.getPayload());
        Assert.assertEquals((Object)TEST_DATA, (Object)uncompressedStr);
    }

    @Test
    public void testCompressDecompressInputStream() throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(TEST_DATA.getBytes());
        LocalMuleClient client = muleContext.getClient();
        MuleMessage compressedResponse = client.send("vm://compressInput", (Object)bis, null);
        Assert.assertNotNull((Object)compressedResponse);
        Assert.assertTrue((boolean)(compressedResponse.getPayload() instanceof InputStream));
        MuleMessage uncompressedResponse = client.send("vm://decompressInput", compressedResponse.getPayload(), null);
        Assert.assertNotNull((Object)uncompressedResponse);
        Assert.assertTrue((boolean)(uncompressedResponse.getPayload() instanceof InputStream));
        byte[] uncompressedByteArray = IOUtils.toByteArray((InputStream)((InputStream)uncompressedResponse.getPayload()));
        String uncompressedStr = new String(uncompressedByteArray);
        Assert.assertEquals((Object)TEST_DATA, (Object)uncompressedStr);
    }

    @Test
    public void testCompressDecompressString() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage compressedResponse = client.send("vm://compressInput", (Object)TEST_DATA, null);
        Assert.assertNotNull((Object)compressedResponse);
        Assert.assertTrue((boolean)(compressedResponse.getPayload() instanceof byte[]));
        byte[] bytes = new GZipCompression().uncompressByteArray((byte[])compressedResponse.getPayload());
        String clientUncompressed = new String(bytes, "UTF8");
        Assert.assertEquals((Object)TEST_DATA, (Object)clientUncompressed);
        MuleMessage uncompressedResponse = client.send("vm://decompressInputString", compressedResponse.getPayload(), null);
        Assert.assertNotNull((Object)uncompressedResponse);
        Assert.assertTrue((boolean)(uncompressedResponse.getPayload() instanceof String));
        Assert.assertEquals((Object)TEST_DATA, (Object)uncompressedResponse.getPayload());
    }
}

