/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.transformers;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.FruitBasket;
import org.mule.tck.testmodels.fruit.FruitBowl;
import org.mule.util.concurrent.Latch;

public class AutoTransformerTestCase
extends AbstractServiceAndFlowTestCase {
    private static Latch latch;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/transformer/auto-transformer-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/transformer/auto-transformer-test-flow.xml"});
    }

    public AutoTransformerTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testInboundAutoTransform() throws Exception {
        latch = new Latch();
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://in", (Object)new FruitBowl(new Apple(), new Banana()), null);
        Assert.assertTrue((boolean)latch.await(3000L, TimeUnit.MILLISECONDS));
    }

    public static class FruitBasketComponent {
        public void process(FruitBasket fb) {
            Assert.assertTrue((boolean)fb.hasApple());
            Assert.assertTrue((boolean)fb.hasBanana());
            latch.countDown();
        }
    }
}

