/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.spring.config;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.custommonkey.xmlunit.XMLUnit;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.common.MuleArtifactFactoryException;
import org.mule.test.spring.config.XmlConfigurationMuleArtifactFactoryTestCase;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class NewDatabaseMuleArtifactTestCase
extends XmlConfigurationMuleArtifactFactoryTestCase {
    @Test(expected=MuleArtifactFactoryException.class)
    public void detectsMissingAttribute() throws SAXException, IOException, MuleArtifactFactoryException {
        Document document = XMLUnit.buildControlDocument((String)"<db:select xmlns:db=\"http://www.mulesoft.org/schema/mule/db\"><db:template-query-ref name=\"template\"/></db:select>");
        DatabaseConfigurationCallback callback = new DatabaseConfigurationCallback();
        NewDatabaseMuleArtifactTestCase.lookupArtifact().getArtifactForMessageProcessor((Object)document.getDocumentElement(), (Object)callback);
    }

    @Test(expected=MuleArtifactFactoryException.class)
    public void detectsMissingDependentElement() throws SAXException, IOException, MuleArtifactFactoryException {
        Document document = XMLUnit.buildControlDocument((String)"<db:select config-ref=\"mysql-config\" xmlns:db=\"http://www.mulesoft.org/schema/mule/db\"><db:template-query-ref name=\"template\"/></db:select>");
        DatabaseConfigurationCallback callback = new DatabaseConfigurationCallback();
        NewDatabaseMuleArtifactTestCase.lookupArtifact().getArtifactForMessageProcessor((Object)document.getDocumentElement(), (Object)callback);
    }

    @Test
    public void validatesDbConnectorGenericMySqlTemplateQueryRefResolution() throws SAXException, IOException, MuleArtifactFactoryException {
        String config = "<db:select config-ref=\"mysql-config\" xmlns:db=\"http://www.mulesoft.org/schema/mule/db\"><db:template-query-ref name=\"template\"/></db:select>";
        Document document = XMLUnit.buildControlDocument((String)config);
        String configRef = "<db:generic-config name=\"mysql-config\" url=\"jdbc:mysql://localhost/test?user=myUser&amp;password=secret\" driverClassName=\"com.mysql.jdbc.Driver\" xmlns:db=\"http://www.mulesoft.org/schema/mule/db\" />";
        String templateRef = "<db:template-query name=\"template\" xmlns:db=\"http://www.mulesoft.org/schema/mule/db\"><db:parameterized-query><![CDATA[SELECT * FROM Users where name = :myParameter1 && lastname= :myParameter2]]></db:parameterized-query><db:in-param name=\"myParameter1\" defaultValue=\"lala\"/><db:in-param name=\"myParameter2\" defaultValue=\"#[payload.parameter2]\"/></db:template-query>";
        HashMap<String, String> callbackData = new HashMap<String, String>();
        callbackData.put("mysql-config", configRef);
        callbackData.put("template", templateRef);
        DatabaseConfigurationCallback callback = new DatabaseConfigurationCallback(callbackData);
        this.doTestMessageProcessorCapabilities(document, callback);
    }

    @Test(expected=MuleArtifactFactoryException.class)
    public void detectsDbConnectorGenericMySqlMissingTemplateQueryRef() throws SAXException, IOException, MuleArtifactFactoryException {
        String config = "<db:select config-ref=\"mysql-config\" xmlns:db=\"http://www.mulesoft.org/schema/mule/db\"><db:template-query-ref name=\"template1\"/></db:select>";
        Document document = XMLUnit.buildControlDocument((String)config);
        String configRef = "<db:generic-config name=\"mysql-config\" url=\"jdbc:mysql://localhost/test?user=myUser&amp;password=secret\" driverClassName=\"com.mysql.jdbc.Driver\" xmlns:db=\"http://www.mulesoft.org/schema/mule/db\" />";
        String templateRef1 = "<db:template-query name=\"template1\" xmlns:db=\"http://www.mulesoft.org/schema/mule/db\"><db:template-query-ref name=\"template2\"/></db:template-query>";
        HashMap<String, String> callbackData = new HashMap<String, String>();
        callbackData.put("mysql-config", configRef);
        callbackData.put("template1", templateRef1);
        DatabaseConfigurationCallback callback = new DatabaseConfigurationCallback(callbackData);
        this.doTestMessageProcessorCapabilities(document, callback);
    }

    @Test
    public void validatesDbConnectorGenericMySqlOverriddenTemplateResolution() throws SAXException, IOException, MuleArtifactFactoryException {
        String config = "<db:select config-ref=\"mysql-config\" xmlns:db=\"http://www.mulesoft.org/schema/mule/db\"><db:template-query-ref name=\"template1\"/></db:select>";
        Document document = XMLUnit.buildControlDocument((String)config);
        String configRef = "<db:generic-config name=\"mysql-config\" url=\"jdbc:mysql://localhost/test?user=myUser&amp;password=secret\" driverClassName=\"com.mysql.jdbc.Driver\" xmlns:db=\"http://www.mulesoft.org/schema/mule/db\" />";
        String templateRef1 = "<db:template-query name=\"template1\" xmlns:db=\"http://www.mulesoft.org/schema/mule/db\"><db:template-query-ref name=\"template2\"/><db:in-param name=\"myParameter1\" defaultValue=\"jeje\"/></db:template-query>";
        String templateRef2 = "<db:template-query name=\"template2\" xmlns:db=\"http://www.mulesoft.org/schema/mule/db\"><db:parameterized-query><![CDATA[SELECT username, password FROM Users where name = :myParameter1 && lastname= :myParameter2]]></db:parameterized-query><db:in-param name=\"myParameter1\" defaultValue=\"jeje\"/><db:in-param name=\"myParameter2\" defaultValue=\"#[payload.parameter]\"/></db:template-query>";
        HashMap<String, String> callbackData = new HashMap<String, String>();
        callbackData.put("mysql-config", configRef);
        callbackData.put("template1", templateRef1);
        callbackData.put("template2", templateRef2);
        DatabaseConfigurationCallback callback = new DatabaseConfigurationCallback(callbackData);
        this.doTestMessageProcessorCapabilities(document, callback);
    }

    @Test
    @Ignore(value="MULE-6926: Flaky test")
    public void validatesDbDerbyConnectorTemplateQueryRefResolution() throws SAXException, IOException, MuleArtifactFactoryException {
        String config = "<db:select config-ref=\"derby-config\" xmlns:db=\"http://www.mulesoft.org/schema/mule/db\"><db:template-query-ref name=\"template\"/></db:select>";
        Document document = XMLUnit.buildControlDocument((String)config);
        String configRef = "<db:derby-config name=\"derby-config\" url=\"jdbc:derby:muleEmbeddedDB;create=true\" xmlns:db=\"http://www.mulesoft.org/schema/mule/db\" driverClassName=\"org.apache.derby.jdbc.EmbeddedDriver\"/>";
        String templateRef = "<db:template-query name=\"template\" xmlns:db=\"http://www.mulesoft.org/schema/mule/db\"><db:parameterized-query><![CDATA[SELECT CURRENT_TIMESTAMP FROM SYSIBM.SYSDUMMY1]]></db:parameterized-query></db:template-query>";
        HashMap<String, String> callbackData = new HashMap<String, String>();
        callbackData.put("derby-config", configRef);
        callbackData.put("template", templateRef);
        DatabaseConfigurationCallback callback = new DatabaseConfigurationCallback(callbackData);
        this.doTestMessageProcessor(document, callback);
    }

    protected static class DatabaseConfigurationCallback
    extends XmlConfigurationMuleArtifactFactoryTestCase.MapXmlConfigurationCallback {
        private static Map<String, String> SCHEMA_MAP = new HashMap<String, String>();

        public DatabaseConfigurationCallback() {
            this(null);
        }

        public DatabaseConfigurationCallback(Map<String, String> refNameToXml) {
            super(refNameToXml, SCHEMA_MAP);
        }

        static {
            SCHEMA_MAP.put("http://www.springframework.org/schema/jdbc", "http://www.springframework.org/schema/jdbc/spring-jdbc.xsd");
            SCHEMA_MAP.put("http://www.mulesoft.org/schema/mule/db", "http://www.mulesoft.org/schema/mule/db/current/mule-db.xsd");
        }
    }
}

