/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.spring.config;

import java.util.HashMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.DOMWriter;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.common.MuleArtifact;
import org.mule.common.MuleArtifactFactoryException;
import org.mule.common.Testable;
import org.mule.common.config.XmlConfigurationCallback;
import org.mule.config.spring.SpringXmlConfigurationMuleArtifactFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.w3c.dom.Element;

public class MessageSourceMuleArtifactTestCase
extends AbstractMuleTestCase {
    private static final String VM_SCHEMA_URL = "http://www.mulesoft.org/schema/mule/vm";
    private SpringXmlConfigurationMuleArtifactFactory factory;
    private MuleArtifact artifact;

    @Before
    public void before() {
        this.factory = new SpringXmlConfigurationMuleArtifactFactory();
    }

    @After
    public void after() {
        if (this.factory != null) {
            this.factory.returnArtifact(this.artifact);
        }
    }

    @Test
    public void createsMessageSourceArtifact() throws MuleArtifactFactoryException, DocumentException {
        XmlConfigurationCallback callback = (XmlConfigurationCallback)Mockito.mock(XmlConfigurationCallback.class);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("test", "test1");
        Mockito.when((Object)callback.getEnvironmentProperties()).thenReturn(map);
        Mockito.when((Object)callback.getPropertyPlaceholders()).thenReturn((Object)new Element[0]);
        Mockito.when((Object)callback.getSchemaLocation(VM_SCHEMA_URL)).thenReturn((Object)"http://www.mulesoft.org/schema/mule/vm/current/mule-vm.xsd");
        Element element = this.createElement("inbound-endpoint", VM_SCHEMA_URL, "vm");
        element.setAttribute("path", "/test");
        this.artifact = this.factory.getArtifactForMessageProcessor(element, callback);
        Assert.assertThat((Object)this.artifact.hasCapability(Testable.class), (Matcher)CoreMatchers.is((Object)false));
    }

    private Element createElement(String name, String namespace, String prefix) throws DocumentException {
        org.dom4j.Element dom4jElement = DocumentHelper.createElement((QName)new QName(name, new Namespace(prefix, namespace)));
        Document dom4jDocument = dom4jElement.getDocument();
        if (dom4jDocument == null) {
            dom4jDocument = DocumentHelper.createDocument();
            dom4jDocument.setRootElement(dom4jElement);
        }
        DOMWriter writer = new DOMWriter();
        org.w3c.dom.Document w3cDocument = writer.write(dom4jDocument);
        Element w3cElement = w3cDocument.getDocumentElement();
        return w3cElement;
    }
}

