/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import com.google.common.collect.Lists;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.tck.junit4.FunctionalTestCase;

public class ForeachUntilSuccessfulTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "for-each-until-config.xml";
    }

    @Test
    public void variablesSyncNoForeach() throws Exception {
        MuleEvent event = this.runAndAssert("varSyncNoForEach", 3);
        Assert.assertThat((Object)((Integer)event.getFlowVariable("until")), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)((Integer)event.getSessionVariable("until")), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void variablesSyncArePropagated() throws Exception {
        MuleEvent event = this.runAndAssert("varSync");
        Assert.assertThat((Object)event.getFlowVariableDataType("mimeVariable").getMimeType(), (Matcher)Matchers.is((Object)"application/json".toString()));
        Assert.assertThat((Object)event.getSessionVariableDataType("mimeSessionVariable").getMimeType(), (Matcher)Matchers.is((Object)"application/json".toString()));
        Assert.assertThat((Object)((Integer)event.getSessionVariable("until")), (Matcher)Matchers.is((Object)3));
    }

    @Test
    public void variablesAsyncArePropagated() throws Exception {
        this.runAndAssert("varAsync");
    }

    private MuleEvent runAndAssert(String flowName) throws Exception {
        return this.runAndAssert(flowName, Lists.newArrayList((Object[])new Integer[]{1, 2, 3}));
    }

    private MuleEvent runAndAssert(String flowName, Object payload) throws Exception {
        MuleEvent event = this.runFlow(flowName, payload);
        Assert.assertThat((Object)((Integer)event.getFlowVariable("count")), (Matcher)Matchers.is((Object)6));
        Assert.assertThat((Object)((Integer)event.getFlowVariable("current")), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)((Integer)event.getSessionVariable("count")), (Matcher)Matchers.is((Object)6));
        Assert.assertThat((Object)((Integer)event.getSessionVariable("current")), (Matcher)Matchers.is((Object)3));
        return event;
    }
}

