/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import java.util.ArrayList;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.junit4.FunctionalTestCase;

public class ForEachSessionVarTestCase
extends FunctionalTestCase {
    protected static MuleEvent event;
    private static final String MY_SESSION_LIST = "mySessionList";

    protected String getConfigFile() {
        return "foreach-session-var-config.xml";
    }

    @Test
    public void testSessionVars() throws Exception {
        ArrayList<String> expectedArray = new ArrayList<String>();
        expectedArray.add("Hello World A");
        expectedArray.add("Hello World B");
        muleContext.getClient().send("vm://in", this.getTestMuleMessage());
        Assert.assertThat((Object)event.getSession().getProperty(MY_SESSION_LIST), (Matcher)Matchers.is(expectedArray));
        Assert.assertThat((Object)event.getMessage().getProperty(MY_SESSION_LIST, PropertyScope.SESSION), (Matcher)Matchers.is(expectedArray));
        event.getSession().removeProperty(MY_SESSION_LIST);
        Assert.assertThat((Object)event.getMessage().getProperty(MY_SESSION_LIST, PropertyScope.SESSION), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    public static class EventSaverProcessor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent receivedEvent) throws MuleException {
            event = receivedEvent;
            return receivedEvent;
        }
    }
}

