/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import org.junit.Test;
import org.mule.api.MessagingException;
import org.mule.test.routing.CustomRouteResolver;
import org.mule.test.routing.DynamicRouterTestCase;

public class DynamicFirstSuccessfulTestCase
extends DynamicRouterTestCase {
    private static final String DYNAMIC_FIRST_SUCCESSFUL = "dynamicFirstSuccessful";
    private static final String DYNAMIC_FIRST_SUCCESSFUL_WITH_EXPRESSION = "dynamicFirstSuccessfulWithExpression";
    private static final String LETTER_F = "f";
    private static final String RANDOM_TEXT_1 = "fafa";
    private static final String RANDOM_TEXT_2 = "fofo";

    protected String getConfigFile() {
        return "org/mule/test/integration/routing/dynamic-first-successful-config.xml";
    }

    @Override
    public String getFlowName() {
        return DYNAMIC_FIRST_SUCCESSFUL;
    }

    @Test
    public void withRoutes() throws Exception {
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor("a"));
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor("b"));
        this.runFlowAndAssertResponse(this.getTestFlow(DYNAMIC_FIRST_SUCCESSFUL), "a");
    }

    @Test
    public void worksWithFirstFailingRouteAndSecondGood() throws Exception {
        CustomRouteResolver.routes.add(new CustomRouteResolver.FailingMessageProcessor());
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor("b"));
        this.runFlowAndAssertResponse(this.getTestFlow(DYNAMIC_FIRST_SUCCESSFUL), "b");
    }

    @Test(expected=MessagingException.class)
    public void worksWithAllFailingProcessor() throws Exception {
        CustomRouteResolver.routes.add(new CustomRouteResolver.FailingMessageProcessor());
        CustomRouteResolver.routes.add(new CustomRouteResolver.FailingMessageProcessor());
        this.runFlowAndAssertResponse(this.getTestFlow(DYNAMIC_FIRST_SUCCESSFUL), "b");
    }

    @Test
    public void allRoutesReceiveSameMessage() throws Exception {
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterTHenFailsMessageProcessor("a"));
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor("b"));
        this.runFlowAndAssertResponse(this.getTestFlow(DYNAMIC_FIRST_SUCCESSFUL), "b");
    }

    @Test
    public void failureExpressionNotFailingNotMatchingExpression() throws Exception {
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor("a"));
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor("b"));
        this.runFlowAndAssertResponse(this.getTestFlow(DYNAMIC_FIRST_SUCCESSFUL_WITH_EXPRESSION), "a");
    }

    @Test
    public void failureExpressionNotFailingButMatchingExpression() throws Exception {
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor(LETTER_F));
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor("b"));
        this.runFlowAndAssertResponse(this.getTestFlow(DYNAMIC_FIRST_SUCCESSFUL_WITH_EXPRESSION), "b");
    }

    @Test(expected=MessagingException.class)
    public void failureExpressionFailingAndMatchingExpression() throws Exception {
        CustomRouteResolver.routes.add(new CustomRouteResolver.FailingMessageProcessor());
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor(LETTER_F));
        this.runFlowAndAssertResponse(this.getTestFlow(DYNAMIC_FIRST_SUCCESSFUL_WITH_EXPRESSION), "doesnotmatter");
    }

    @Test(expected=MessagingException.class)
    public void allFailingExpression() throws Exception {
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor(RANDOM_TEXT_1));
        CustomRouteResolver.routes.add(new CustomRouteResolver.AddLetterMessageProcessor(RANDOM_TEXT_2));
        this.runFlowAndAssertResponse(this.getTestFlow(DYNAMIC_FIRST_SUCCESSFUL_WITH_EXPRESSION), "doesnotmatter");
    }
}

