/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.functional.FunctionalTestComponent;

public class CorrelationResequencerTestCase
extends AbstractServiceAndFlowTestCase {
    private CountDownLatch receiveLatch = new CountDownLatch(6);

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "correlation-resequencer-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "correlation-resequencer-test-flow.xml"});
    }

    public CorrelationResequencerTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        FunctionalTestComponent testComponent = this.getFunctionalTestComponent("test validator");
        testComponent.setEventCallback(new EventCallback(){

            public void eventReceived(MuleEventContext context, Object component) throws Exception {
                CorrelationResequencerTestCase.this.receiveLatch.countDown();
            }
        });
    }

    @Test
    public void testResequencer() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://splitter", Arrays.asList("a", "b", "c", "d", "e", "f"), null);
        FunctionalTestComponent resequencer = this.getFunctionalTestComponent("test validator");
        Assert.assertTrue((boolean)this.receiveLatch.await(30L, TimeUnit.SECONDS));
        Assert.assertEquals((String)"Wrong number of messages received.", (long)6L, (long)resequencer.getReceivedMessagesCount());
        Assert.assertEquals((String)"Sequence wasn't reordered.", (Object)"a", (Object)resequencer.getReceivedMessage(1));
        Assert.assertEquals((String)"Sequence wasn't reordered.", (Object)"b", (Object)resequencer.getReceivedMessage(2));
        Assert.assertEquals((String)"Sequence wasn't reordered.", (Object)"c", (Object)resequencer.getReceivedMessage(3));
        Assert.assertEquals((String)"Sequence wasn't reordered.", (Object)"d", (Object)resequencer.getReceivedMessage(4));
        Assert.assertEquals((String)"Sequence wasn't reordered.", (Object)"e", (Object)resequencer.getReceivedMessage(5));
        Assert.assertEquals((String)"Sequence wasn't reordered.", (Object)"f", (Object)resequencer.getReceivedMessage(6));
    }
}

