/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Test;
import org.mule.api.MuleMessageCollection;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;

public class CollectionAggregatorSplitterMultipleRoutersTestCase
extends FunctionalTestCase {
    private static final List<Integer> TEST_LIST = Arrays.asList(1, 2, 3);

    protected String getConfigFile() {
        return "collection-aggregator-splitter-multiple-routers.xml";
    }

    @Test
    public void multipleCollectionSplitterAggregatorPreservesPayload() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        this.runFlow("multiple-splitter-aggregator-payload-preserved", CollectionAggregatorSplitterMultipleRoutersTestCase.getTestMuleMessage(TEST_LIST));
        MuleMessageCollection request = (MuleMessageCollection)client.request("vm://out?connector=queue", 10000L);
        MatcherAssert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat(TEST_LIST, (Matcher)IsCollectionWithSize.hasSize((int)request.size()));
        MatcherAssert.assertThat(TEST_LIST, (Matcher)Matchers.contains((Object[])request.getPayloadsAsArray()));
    }

    @Test
    public void multipleCollectionSplitterAggregatorTransformedPayloadIsPreserved() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        List<Integer> resultList = Arrays.asList(24, 48, 72);
        this.runFlow("multiple-splitter-aggregator-successive-payload-transformations", CollectionAggregatorSplitterMultipleRoutersTestCase.getTestMuleMessage(TEST_LIST));
        MuleMessageCollection request = (MuleMessageCollection)client.request("vm://out?connector=queue", 10000L);
        MatcherAssert.assertThat((Object)request, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        MatcherAssert.assertThat(resultList, (Matcher)IsCollectionWithSize.hasSize((int)request.size()));
        MatcherAssert.assertThat(resultList, (Matcher)Matchers.contains((Object[])request.getPayloadsAsArray()));
    }
}

