/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.SerializationException;
import org.apache.commons.lang.SerializationUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessageCollection;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.store.ObjectStoreException;
import org.mule.routing.EventGroup;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.store.SimpleMemoryObjectStore;

public class CollectionAggregatorRouterSerializationTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "collection-aggregator-router-serialization.xml";
    }

    @Test
    public void eventGroupDeserialization() throws Exception {
        muleContext.getRegistry().registerObject("_defaultInMemoryObjectStore", new EventGroupSerializerObjectStore());
        LocalMuleClient client = muleContext.getClient();
        List<String> list = Arrays.asList("first", "second");
        client.dispatch("vm://splitter", list, null);
        MuleMessageCollection request = (MuleMessageCollection)client.request("vm://out?connector=queue", 10000L);
        Assert.assertNotNull((Object)request);
        Assert.assertEquals((long)list.size(), (long)request.size());
    }

    private class EventGroupSerializerObjectStore<T extends Serializable>
    extends SimpleMemoryObjectStore<Serializable> {
        private EventGroupSerializerObjectStore() {
        }

        protected void doStore(Serializable key, Serializable value) throws ObjectStoreException {
            if (value instanceof EventGroup) {
                value = SerializationUtils.serialize((Serializable)value);
            }
            super.doStore(key, (Serializable)value);
        }

        protected Serializable doRetrieve(Serializable key) {
            Object value = super.doRetrieve(key);
            if (value instanceof byte[]) {
                try {
                    value = SerializationUtils.deserialize((byte[])((byte[])value));
                }
                catch (SerializationException serializationException) {
                    // empty catch block
                }
            }
            return value;
        }
    }
}

