/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.routing;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.util.concurrent.Latch;

public abstract class AbstractSynchronizedMuleContextStartTestCase
extends FunctionalTestCase {
    protected static volatile int processedMessageCounter = 0;
    protected static final Latch waitMessageInProgress = new Latch();

    public AbstractSynchronizedMuleContextStartTestCase() {
        this.setStartContext(false);
    }

    @Before
    public void setUp() {
        processedMessageCounter = 0;
    }

    @Test
    public void waitsForStartedMuleContextBeforeAttemptingToSendMessageToEndpoint() throws Exception {
        this.prePopulateObjectStore();
        muleContext.start();
        PollingProber prober = new PollingProber(5000L, 50L);
        prober.check(new Probe(){

            public boolean isSatisfied() {
                return processedMessageCounter == 1;
            }

            public String describeFailure() {
                return "Did not wait for mule context started before attempting to process event";
            }
        });
    }

    private void prePopulateObjectStore() throws ObjectStoreException {
        ObjectStore objectStore = (ObjectStore)muleContext.getRegistry().lookupObject("objectStore");
        DefaultMuleMessage testMessage = new DefaultMuleMessage((Object)"Test Message", muleContext);
        Flow clientFlow = (Flow)muleContext.getRegistry().get("flow2");
        DefaultMuleEvent testMuleEvent = new DefaultMuleEvent((MuleMessage)testMessage, MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)clientFlow);
        objectStore.store((Serializable)((Object)testMuleEvent.getId()), (Serializable)testMuleEvent);
    }

    public static class TestMessageProcessor {
        public String count(String value) throws InterruptedException {
            if (waitMessageInProgress.await(0L, TimeUnit.MILLISECONDS)) {
                ++processedMessageCounter;
            }
            return value;
        }
    }
}

