/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.issues;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.api.transformer.Transformer;
import org.mule.construct.Flow;
import org.mule.routing.MessageFilter;
import org.mule.tck.junit4.FunctionalTestCase;

public class Mule5038TestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/issues/mule-5038-config.xml";
    }

    @Test
    public void testTransformerOnGlobalEndpoint() {
        Flow flow1 = (Flow)muleContext.getRegistry().lookupObject("flow1");
        Filter flow1Filter = ((MessageFilter)flow1.getMessageProcessors().get(0)).getFilter();
        Flow flow2 = (Flow)muleContext.getRegistry().lookupObject("flow2");
        Filter flow2Filter = ((MessageFilter)flow2.getMessageProcessors().get(0)).getFilter();
        Assert.assertNotSame((Object)flow1Filter, (Object)flow2Filter);
    }

    @Test
    public void testFilterOnGlobalEndpoint() {
        Flow flow1 = (Flow)muleContext.getRegistry().lookupObject("flow1");
        Transformer flow1Transoformer = (Transformer)flow1.getMessageProcessors().get(1);
        Flow flow2 = (Flow)muleContext.getRegistry().lookupObject("flow2");
        Transformer flow2Transoformer = (Transformer)flow2.getMessageProcessors().get(1);
        Assert.assertNotSame((Object)flow1Transoformer, (Object)flow2Transoformer);
    }

    @Test
    public void testCustomProcessorOnGlobalEndpoint() {
        Flow flow1 = (Flow)muleContext.getRegistry().lookupObject("flow1");
        MessageProcessor flow1Processor = (MessageProcessor)flow1.getMessageProcessors().get(3);
        Flow flow2 = (Flow)muleContext.getRegistry().lookupObject("flow2");
        MessageProcessor flow2Processor = (MessageProcessor)flow2.getMessageProcessors().get(3);
        Assert.assertNotSame((Object)flow1Processor, (Object)flow2Processor);
    }

    @Test
    public void testCompositeProcessorOnGlobalEndpoint() {
        Flow flow1 = (Flow)muleContext.getRegistry().lookupObject("flow1");
        MessageProcessor flow1Processor = (MessageProcessor)flow1.getMessageProcessors().get(2);
        Flow flow2 = (Flow)muleContext.getRegistry().lookupObject("flow2");
        MessageProcessor flow2Processor = (MessageProcessor)flow2.getMessageProcessors().get(2);
        Assert.assertNotSame((Object)flow1Processor, (Object)flow2Processor);
    }
}

