/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.xml;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.junit4.rule.DynamicPort;

public class XmlSendTestCase
extends AbstractServiceAndFlowTestCase {
    @Rule
    public DynamicPort dynamicPort = new DynamicPort("port1");

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/xml/xml-conf-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/xml/xml-conf-flow.xml"});
    }

    public XmlSendTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testXmlFilter() throws Exception {
        InputStream xml = ((Object)((Object)this)).getClass().getResourceAsStream("request.xml");
        Assert.assertNotNull((Object)xml);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/xml-parse", XmlSendTestCase.getTestMuleMessage((Object)xml));
        Assert.assertEquals((Object)"200", (Object)message.getInboundProperty("http.status"));
        xml = ((Object)((Object)this)).getClass().getResourceAsStream("validation1.xml");
        message = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/xml-parse", XmlSendTestCase.getTestMuleMessage((Object)xml));
        Assert.assertEquals((Object)"406", (Object)message.getInboundProperty("http.status"));
    }

    @Test
    public void testXmlFilterAndXslt() throws Exception {
        InputStream xml = ((Object)((Object)this)).getClass().getResourceAsStream("request.xml");
        Assert.assertNotNull((Object)xml);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/xml-xslt-parse", XmlSendTestCase.getTestMuleMessage((Object)xml));
        Assert.assertEquals((Object)"200", (Object)message.getInboundProperty("http.status"));
    }

    @Test
    public void testXmlValidation() throws Exception {
        InputStream xml = ((Object)((Object)this)).getClass().getResourceAsStream("validation1.xml");
        Assert.assertNotNull((Object)xml);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/validate", XmlSendTestCase.getTestMuleMessage((Object)xml));
        Assert.assertEquals((Object)"200", (Object)message.getInboundProperty("http.status"));
        xml = ((Object)((Object)this)).getClass().getResourceAsStream("validation2.xml");
        message = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/validate", XmlSendTestCase.getTestMuleMessage((Object)xml));
        Assert.assertEquals((Object)"406", (Object)message.getInboundProperty("http.status"));
        xml = ((Object)((Object)this)).getClass().getResourceAsStream("validation3.xml");
        message = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/validate", XmlSendTestCase.getTestMuleMessage((Object)xml));
        Assert.assertEquals((Object)"200", (Object)message.getInboundProperty("http.status"));
    }

    @Test
    public void testExtractor() throws Exception {
        InputStream xml = ((Object)((Object)this)).getClass().getResourceAsStream("validation1.xml");
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("http://localhost:" + this.dynamicPort.getNumber() + "/extract", XmlSendTestCase.getTestMuleMessage((Object)xml));
        Assert.assertThat((Object)message.getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)"some"));
    }
}

