/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.util;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.StringStartsWith;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.ObjectNameHelper;

public class ObjectNameHelperTestCase
extends AbstractMuleContextTestCase {
    public static final String UNIQUE_NAME_PREFIX = "unique-name-prefix";

    @Ignore
    @Test
    public void endpointAutomaticNames() throws Exception {
        InboundEndpoint ep = muleContext.getEndpointFactory().getInboundEndpoint("test://cn=foo,name=queue");
        muleContext.getRegistry().registerEndpoint((ImmutableEndpoint)ep);
        Assert.assertEquals((Object)"endpoint.test.cn.foo.name.queue", (Object)ep.getName());
        ep = muleContext.getEndpointFactory().getInboundEndpoint("test://cn=foo,name=queue");
        Assert.assertEquals((Object)"endpoint.test.cn.foo.name.queue.1", (Object)ep.getName());
        ep = muleContext.getEndpointFactory().getInboundEndpoint("vm://my.queue");
        Assert.assertEquals((Object)"endpoint.vm.my.queue", (Object)ep.getName());
        ep = muleContext.getEndpointFactory().getInboundEndpoint("pop3://ross:secret@mail.mycompany.com?subject=foo");
        Assert.assertEquals((Object)"endpoint.pop3.ross.mycompany.com", (Object)ep.getName());
    }

    @Test
    @Ignore
    public void endpointNameGenerationWithParams() throws Exception {
        InboundEndpoint ep = muleContext.getEndpointFactory().getInboundEndpoint("test://cn=foo,name=queue?endpointName=foo");
        muleContext.getRegistry().registerEndpoint((ImmutableEndpoint)ep);
        Assert.assertEquals((Object)"endpoint.test.cn.foo.name.queue", (Object)ep.getName());
        ep = muleContext.getEndpointFactory().getInboundEndpoint("test://cn=foo,name=queue?endpointName=this_is@aWierd-Name:x");
        Assert.assertEquals((Object)"this.is.aWierd.Name.x", (Object)ep.getName());
        muleContext.getRegistry().registerEndpoint((ImmutableEndpoint)ep);
        ep = muleContext.getEndpointFactory().getInboundEndpoint("test://cn=foo,name=queue?endpointName=this_is@aWierd-Name:x");
        Assert.assertEquals((Object)"this.is.aWierd.Name.x", (Object)ep.getName());
        ep = muleContext.getEndpointFactory().getInboundEndpoint("test://cn=foo,name=queue?endpointName=this____is+another=@Wierd----Name:x:::");
        Assert.assertEquals((Object)"this.is.another.Wierd.Name.x", (Object)ep.getName());
    }

    @Ignore
    @Test
    public void endpointNameGeneration() throws Exception {
        InboundEndpoint ep = muleContext.getEndpointFactory().getInboundEndpoint("test://exception.listener");
        muleContext.getRegistry().registerEndpoint((ImmutableEndpoint)ep);
        Assert.assertEquals((Object)"endpoint.test.exception.listener", (Object)ep.getName());
    }

    @Test
    public void uniqueNameGeneration() throws Exception {
        ObjectNameHelper objectNameHelper = new ObjectNameHelper(muleContext);
        String uniqueName = objectNameHelper.getUniqueName(UNIQUE_NAME_PREFIX);
        Assert.assertThat((Object)uniqueName, (Matcher)StringStartsWith.startsWith((String)UNIQUE_NAME_PREFIX));
        String secondUniqueName = objectNameHelper.getUniqueName(UNIQUE_NAME_PREFIX);
        Assert.assertThat((Object)secondUniqueName, (Matcher)StringStartsWith.startsWith((String)UNIQUE_NAME_PREFIX));
        Assert.assertThat((Object)uniqueName, (Matcher)IsNot.not((Matcher)Is.is((Object)secondUniqueName)));
        String nextName = "unique-name-prefix-2";
        muleContext.getRegistry().registerObject("unique-name-prefix-2", (Object)"");
        String thirdUniqueName = objectNameHelper.getUniqueName(UNIQUE_NAME_PREFIX);
        Assert.assertThat((Object)thirdUniqueName, (Matcher)IsNot.not((Matcher)Is.is((Object)"unique-name-prefix-2")));
    }
}

