/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transaction.xa;

import org.mule.tck.util.MuleDerbyTestDatabase;
import org.mule.test.integration.transaction.xa.TransactionScenarios;
import org.mule.test.integration.transaction.xa.TransactionalTestSetUp;

public class JdbcDatabaseSetUp
implements TransactionalTestSetUp {
    private final MuleDerbyTestDatabase muleDerbyTestDatabase;

    private JdbcDatabaseSetUp(String databaseNameProperty) {
        this.muleDerbyTestDatabase = new MuleDerbyTestDatabase(databaseNameProperty);
    }

    public static JdbcDatabaseSetUp createDatabaseOne() {
        return new JdbcDatabaseSetUp("database.name");
    }

    public static JdbcDatabaseSetUp createDatabaseTwo() {
        return new JdbcDatabaseSetUp("database.name2");
    }

    @Override
    public void initialize() throws Exception {
        this.muleDerbyTestDatabase.startDatabase();
    }

    @Override
    public void finalice() throws Exception {
        this.muleDerbyTestDatabase.stopDatabase();
    }

    public TransactionScenarios.InboundMessagesGenerator createInboundMessageCreator() {
        return new TransactionScenarios.InboundMessagesGenerator(){

            @Override
            public Integer generateInboundMessages() throws Exception {
                JdbcDatabaseSetUp.this.muleDerbyTestDatabase.emptyTestTable();
                for (int i = 0; i < 6; ++i) {
                    JdbcDatabaseSetUp.this.muleDerbyTestDatabase.insertIntoTest("test " + i, 1);
                }
                return 6;
            }
        };
    }

    public TransactionScenarios.OutboundMessagesCounter createOutboundMessageCreator() {
        return new TransactionScenarios.OutboundMessagesCounter(){

            @Override
            public int numberOfMessagesThatArrived() throws Exception {
                return JdbcDatabaseSetUp.this.muleDerbyTestDatabase.execSqlQuery("SELECT * FROM TEST WHERE TYPE = 2").size();
            }

            @Override
            public void close() {
            }
        };
    }
}

