/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.transaction;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsNull;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;

public class TransactionExpressionFilterTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/integration/transaction/transaction-expression-filter-test-config.xml";
    }

    @Test
    public void transactionWithNestedExpressionFilterEvaluatesFalseStopsFlowAndReturnsNull() throws Exception {
        MuleMessage reply = this.sendTestMessageVmQueueEndpoint("transaction-filter-all", "transaction-filter-all-reply");
        MatcherAssert.assertThat((Object)reply, (Matcher)IsNull.nullValue());
    }

    @Test
    public void transactionWithNestedExpressionFilterEvaluatesTrueReturnsPayload() throws Exception {
        MuleMessage reply = this.sendTestMessageVmQueueEndpoint("transaction-filter-nothing", "transaction-filter-nothing-reply");
        MatcherAssert.assertThat((Object)reply.getPayload().toString(), (Matcher)Is.is((Matcher)IsEqual.equalTo((Object)"Test Message")));
    }

    public MuleMessage sendTestMessageVmQueueEndpoint(String inQueue, String outQueue) throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://" + inQueue, (Object)"Test Message", null);
        return client.request("vm://" + outQueue, 5000L);
    }
}

