/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.tck;

import java.io.FileNotFoundException;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.util.ExceptionUtils;

public class MuleTestNamespaceFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/tck/test-namespace-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/tck/test-namespace-config-flow.xml"});
    }

    public MuleTestNamespaceFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testService1() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://service1", (Object)"foo", null);
        Assert.assertNotNull((Object)message);
        Assert.assertNull((Object)message.getExceptionPayload());
        Assert.assertEquals((Object)"Foo Bar Car Jar", (Object)message.getPayloadAsString());
    }

    @Test
    public void testService2() throws Exception {
        String result = this.loadResourceAsString("org/mule/test/integration/tck/test-data.txt");
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://service2", (Object)"foo", null);
        Assert.assertNotNull((Object)message);
        Assert.assertNull((Object)message.getExceptionPayload());
        Assert.assertEquals((Object)result, (Object)message.getPayloadAsString());
    }

    @Test
    public void testService3() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage message = client.send("vm://service3", (Object)"foo", null);
        Assert.assertNotNull((Object)message);
        Assert.assertNull((Object)message.getExceptionPayload());
        Assert.assertEquals((Object)"foo received in testService3", (Object)message.getPayloadAsString());
    }

    @Test
    public void testService4() throws Exception {
        try {
            LocalMuleClient client = muleContext.getClient();
            client.send("vm://service4", (Object)"foo", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testService5() throws Exception {
        try {
            LocalMuleClient client = muleContext.getClient();
            client.send("vm://service5", (Object)"foo", null);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(ExceptionUtils.getRootCause((Throwable)e) instanceof FileNotFoundException));
        }
    }
}

