/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.streaming;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.client.MuleClient;
import org.mule.module.xml.stax.DelegateXMLStreamReader;
import org.mule.module.xml.stax.StaxSource;
import org.mule.module.xml.util.XMLUtils;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.probe.PollingProber;
import org.mule.tck.probe.Probe;
import org.mule.util.concurrent.Latch;
import org.xml.sax.InputSource;

public class CloseStreamOnMuleExceptionTestCase
extends AbstractServiceAndFlowTestCase {
    private final int timeoutMs = 3000;
    private static Latch inputStreamLatch = new Latch();
    private static Latch streamReaderLatch;
    private String xmlText = "<test attribute=\"1\"/>";
    private TestByteArrayInputStream inputStream;
    private MuleClient client;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/streaming/close-stream-on-mule-exception-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/streaming/close-stream-on-mule-exception-test-flow.xml"});
    }

    public CloseStreamOnMuleExceptionTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.client = muleContext.getClient();
        this.inputStream = new TestByteArrayInputStream(this.xmlText.getBytes());
        streamReaderLatch = new Latch();
    }

    @Test
    public void testCloseStreamOnComponentException() throws Exception {
        this.client.dispatch("vm://inEcho?connector=vm", (Object)this.inputStream, null);
        streamReaderLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)this.inputStream.isClosed());
    }

    @Test
    public void testCloseXMLInputSourceOnComponentException() throws Exception {
        InputSource stream = new InputSource(this.inputStream);
        this.client.dispatch("vm://inEcho?connector=vm", (Object)stream, null);
        streamReaderLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)((TestByteArrayInputStream)stream.getByteStream()).isClosed());
    }

    @Test
    public void testCloseXMLStreamSourceOnComponentException() throws Exception {
        Source stream = XMLUtils.toXmlSource((XMLInputFactory)XMLInputFactory.newInstance(), (boolean)false, (Object)this.inputStream);
        this.client.dispatch("vm://inEcho?connector=vm", (Object)stream, null);
        streamReaderLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)((TestByteArrayInputStream)((StreamSource)stream).getInputStream()).isClosed());
    }

    @Test
    public void testCloseXMLStreamReaderOnComponentException() throws Exception {
        TestXMLStreamReader stream = new TestXMLStreamReader(XMLInputFactory.newInstance().createXMLStreamReader(this.inputStream));
        this.client.dispatch("vm://inEcho?connector=vm", (Object)stream, null);
        streamReaderLatch.await(3000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)stream.isClosed());
    }

    @Test
    public void testCloseSaxSourceOnComponentException() throws Exception {
        SAXSource stream = new SAXSource(new InputSource(this.inputStream));
        this.client.dispatch("vm://inEcho?connector=vm", (Object)stream, null);
        this.verifyInputStreamIsClosed((TestByteArrayInputStream)stream.getInputSource().getByteStream());
    }

    @Test
    public void testCloseStaxSourceOnComponentException() throws Exception {
        StaxSource stream = new StaxSource((XMLStreamReader)((Object)new TestXMLStreamReader(XMLInputFactory.newInstance().createXMLStreamReader(this.inputStream))));
        this.client.dispatch("vm://inEcho?connector=vm", (Object)stream, null);
        this.verifyInputStreamIsClosed((TestXMLStreamReader)((Object)stream.getXMLStreamReader()));
    }

    @Test
    public void testCloseStreamOnDispatcherException() throws Exception {
        this.client.dispatch("vm://dispatcherExceptionBridge?connector=vm", (Object)this.inputStream, null);
        this.verifyInputStreamIsClosed(this.inputStream);
    }

    @Test
    public void testCloseStreamOnInboundFilterException() throws Exception {
        this.client.dispatch("vm://inboundFilterExceptionBridge?connector=vm", (Object)this.inputStream, null);
        this.verifyInputStreamIsClosed(this.inputStream);
    }

    private void verifyInputStreamIsClosed(final ClosableInputStream is) {
        PollingProber pollingProber = new PollingProber(3000L, 100L);
        pollingProber.check(new Probe(){

            public boolean isSatisfied() {
                return is.isClosed();
            }

            public String describeFailure() {
                return "Input stream was never closed";
            }
        });
    }

    static class TestXMLStreamReader
    extends DelegateXMLStreamReader
    implements ClosableInputStream {
        private boolean closed;

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        public TestXMLStreamReader(XMLStreamReader reader) {
            super(reader);
        }

        public void close() throws XMLStreamException {
            super.close();
            this.closed = true;
            streamReaderLatch.countDown();
        }
    }

    static class TestByteArrayInputStream
    extends ByteArrayInputStream
    implements ClosableInputStream {
        private boolean closed;

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        public TestByteArrayInputStream(byte[] arg0) {
            super(arg0);
        }

        public TestByteArrayInputStream(byte[] buf, int offset, int length) {
            super(buf, offset, length);
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.closed = true;
            inputStreamLatch.countDown();
        }
    }

    static interface ClosableInputStream {
        public boolean isClosed();
    }
}

