/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.service;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.endpoint.InboundEndpoint;
import org.mule.api.service.Service;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.tck.junit4.FunctionalTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInFlightMessagesTestCase
extends FunctionalTestCase {
    protected static final int WAIT_TIME_MILLIS = 500;
    protected static final int NUM_MESSAGES = 500;
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceInFlightMessagesTestCase.class);

    protected String getConfigFile() {
        return "org/mule/test/integration/service/service-inflight-messages.xml";
    }

    protected MuleContext createMuleContext() throws Exception {
        MuleContext context = super.createMuleContext();
        ((DefaultMuleConfiguration)context.getConfiguration()).setShutdownTimeout(500);
        return context;
    }

    protected void doTearDown() throws Exception {
        FileUtils.deleteDirectory((File)new File(muleContext.getConfiguration().getWorkingDirectory()));
        super.doTearDown();
    }

    @Test
    public void testInFlightMessagesWhenServiceStopped() throws Exception {
        Service service = muleContext.getRegistry().lookupService("TestService");
        this.populateSedaQueue(service, 500);
        this.stopService(service);
        this.assertNoLostMessages(500, service);
        this.assertSedaQueueEmpty(service);
    }

    @Test
    public void testInFlightMessagesPausedServiceWhenServiceStopped() throws Exception {
        Service service = muleContext.getRegistry().lookupService("PausedTestService");
        this.populateSedaQueue(service, 500);
        this.stopService(service);
        this.assertNoLostMessages(500, service);
        this.assertOutboundEmpty();
    }

    @Test
    @Ignore(value="MULE-6926: flaky test (caused by usage of Thead.sleep)")
    public void testInFlightMessagesPersistentQueueServiceWhenServiceStopped() throws Exception {
        Service service = muleContext.getRegistry().lookupService("TestPersistentQueueService");
        this.populateSedaQueue(service, 500);
        this.stopService(service);
        this.assertNoLostMessages(500, service);
        this.startService(service);
        Thread.sleep(1000L);
        this.stopService(service);
        this.assertNoLostMessages(500, service);
        this.startService(service);
        Thread.sleep(5000L);
        this.stopService(service);
        this.assertNoLostMessages(500, service);
        this.assertSedaQueueEmpty(service);
    }

    @Test
    @Ignore(value="MULE-6926: flaky test (caused by usage of Thead.sleep)")
    public void testInFlightMessagesPausedPersistentQueueServiceWhenServiceStopped() throws Exception {
        Service service = muleContext.getRegistry().lookupService("PausedTestPersistentQueueService");
        this.populateSedaQueue(service, 500);
        this.stopService(service);
        this.assertOutboundEmpty();
        this.assertNoLostMessages(500, service);
        this.startService(service);
        service.resume();
        Thread.sleep(1000L);
        this.stopService(service);
        this.assertNoLostMessages(500, service);
        this.startService(service);
        service.resume();
        Thread.sleep(10000L);
        this.stopService(service);
        this.assertNoLostMessages(500, service);
        this.assertSedaQueueEmpty(service);
    }

    @Test
    @Ignore(value="MULE-6926: flaky test (caused by usage of Thead.sleep)")
    public void testInFlightMessagesPersistentQueueServiceWhenMuleDisposed() throws Exception {
        Service service = muleContext.getRegistry().lookupService("TestPersistentQueueService");
        this.populateSedaQueue(service, 500);
        muleContext.dispose();
        this.assertNoLostMessages(500, service);
        this.recreateAndStartMuleContext();
        Thread.sleep(500L);
        muleContext.dispose();
        this.assertNoLostMessages(500, service);
        this.recreateAndStartMuleContext();
        Thread.sleep(5000L);
        muleContext.dispose();
        this.assertNoLostMessages(500, service);
        this.assertSedaQueueEmpty(service);
    }

    protected void recreateAndStartMuleContext() throws Exception, MuleException {
        muleContext = this.createMuleContext();
        muleContext.start();
    }

    protected void populateSedaQueue(Service service, int numMessages) throws MuleException, Exception {
        for (int i = 0; i < numMessages; ++i) {
            service.dispatchEvent(ServiceInFlightMessagesTestCase.getTestEvent((Object)"test", (Service)service, (InboundEndpoint)muleContext.getEndpointFactory().getInboundEndpoint("test://test")));
        }
    }

    protected synchronized void assertNoLostMessages(int numMessages, Service service) throws Exception {
        LOGGER.info("SEDA Queue: " + this.getSedaQueueSize(service) + ", Outbound endpoint: " + this.getOutSize());
        Assert.assertEquals((long)numMessages, (long)(this.getOutSize() + this.getSedaQueueSize(service)));
    }

    protected synchronized void assertSedaQueueEmpty(Service service) throws MuleException {
        Assert.assertEquals((long)0L, (long)this.getSedaQueueSize(service));
    }

    protected synchronized void assertSedaQueueNotEmpty(Service service) throws MuleException {
        Assert.assertTrue((String)String.format("Seda queue for service '%s' is empty", service.getName()), (this.getSedaQueueSize(service) > 0 ? 1 : 0) != 0);
    }

    protected synchronized void assertOutboundEmpty() throws Exception {
        Assert.assertEquals((long)0L, (long)this.getOutSize());
    }

    protected synchronized void assertOutboundNotEmpty() throws Exception {
        Assert.assertTrue((String)"VM Out queue is empty", (this.getOutSize() > 0 ? 1 : 0) != 0);
    }

    protected int getSedaQueueSize(Service service) throws MuleException {
        return this.getQueueSize(this.getSedaQueueName(service));
    }

    protected String getSedaQueueName(Service service) {
        return "seda.queue(" + service.getName() + ")";
    }

    protected int getOutSize() throws Exception {
        return this.getQueueSize("out");
    }

    protected int getQueueSize(String name) throws MuleException {
        if (muleContext != null && muleContext.isStarted()) {
            return muleContext.getQueueManager().getQueueSession().getQueue(name).size();
        }
        MuleContext localMuleContext = new DefaultMuleContextBuilder().buildMuleContext();
        String workingDirectory = localMuleContext.getConfiguration().getWorkingDirectory();
        String path = workingDirectory + File.separator + "queuestore" + File.separator + name;
        File[] filesInQueue = new File(path).listFiles();
        return filesInQueue.length;
    }

    protected void stopService(Service service) throws Exception {
        service.stop();
        muleContext.getRegistry().lookupConnector("outPersistentConnector").stop();
    }

    protected void startService(Service service) throws Exception {
        muleContext.getRegistry().lookupConnector("outPersistentConnector").start();
        service.start();
    }
}

