/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.security;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.IOUtils;

public class HttpListenerAuthenticationTestCase
extends FunctionalTestCase {
    private static final String BASIC_REALM_MULE_REALM = "Basic realm=\"mule-realm\"";
    private static final String VALID_USER = "user";
    private static final String VALID_PASSWORD = "password";
    private static final String INVALID_PASSWORD = "invalidPassword";
    private static final String EXPECTED_PAYLOAD = "TestBasicAuthOk";
    CloseableHttpClient httpClient;
    CloseableHttpResponse httpResponse;
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");

    protected String getConfigFile() {
        return "org/mule/test/integration/security/http-listener-authentication-config.xml";
    }

    @After
    public void tearDown() {
        IOUtils.closeQuietly((Closeable)this.httpResponse);
        IOUtils.closeQuietly((Closeable)this.httpClient);
    }

    @Test
    public void invalidBasicAuthentication() throws Exception {
        CredentialsProvider credsProvider = this.getCredentialsProvider(VALID_USER, INVALID_PASSWORD);
        this.getHttpResponse(credsProvider);
        Assert.assertThat((Object)this.httpResponse.getStatusLine().getStatusCode(), (Matcher)Is.is((Object)401));
        Header authHeader = this.httpResponse.getFirstHeader("WWW-Authenticate");
        Assert.assertThat((Object)authHeader, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)authHeader.getValue(), (Matcher)Is.is((Object)BASIC_REALM_MULE_REALM));
    }

    @Test
    public void validBasicAuthentication() throws Exception {
        CredentialsProvider credsProvider = this.getCredentialsProvider(VALID_USER, VALID_PASSWORD);
        this.getHttpResponse(credsProvider);
        Assert.assertThat((Object)this.httpResponse.getStatusLine().getStatusCode(), (Matcher)Is.is((Object)200));
        Assert.assertThat((Object)IOUtils.toString((InputStream)this.httpResponse.getEntity().getContent()), (Matcher)Is.is((Object)EXPECTED_PAYLOAD));
    }

    private void getHttpResponse(CredentialsProvider credsProvider) throws IOException {
        HttpPost httpPost = new HttpPost(String.format("http://localhost:%s/basic", this.listenPort.getNumber()));
        this.httpClient = HttpClients.custom().setDefaultCredentialsProvider(credsProvider).build();
        this.httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
    }

    private CredentialsProvider getCredentialsProvider(String user, String password) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
        return credsProvider;
    }
}

