/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.security;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Rule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.api.lifecycle.Callable;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

@RunWith(value=Parameterized.class)
public abstract class AbstractHttpAuthenticationRequestTimeoutTestCase
extends FunctionalTestCase {
    private static Integer timeout;
    private static Integer delay;
    @Rule
    public SystemProperty timeoutSystemProperty;
    @Rule
    public SystemProperty isPreemptiveSystemProperty;
    @Rule
    public DynamicPort port = new DynamicPort("port");

    public AbstractHttpAuthenticationRequestTimeoutTestCase(String isPreemptive) {
        timeout = this.getTimeout();
        delay = this.getDelay();
        this.timeoutSystemProperty = new SystemProperty("timeout", timeout.toString());
        this.isPreemptiveSystemProperty = new SystemProperty("isPreemptive", isPreemptive);
    }

    @Parameterized.Parameters
    public static Collection<Object> data() {
        return Arrays.asList("true", "false");
    }

    protected String getConfigFile() {
        return "http-response-timeout-config.xml";
    }

    protected abstract int getTimeout();

    protected abstract int getDelay();

    public static class DelayComponent
    implements Callable {
        public Object onCall(MuleEventContext eventContext) throws Exception {
            Thread.sleep(delay.intValue());
            return eventContext.getMessage().getPayload();
        }
    }
}

