/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing.outbound;

import org.custommonkey.xmlunit.XMLUnit;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.MuleClient;
import org.mule.tck.junit4.FunctionalTestCase;

@Ignore(value="MULE-4483")
public class ExpressionSplitterXPathWithFiltersTestCase
extends FunctionalTestCase {
    private static final String MESSAGE = "<Foo>\n    <Bar>\n        <One>One</One>\n        <Three>Three</Three>\n        <Two>Two</Two>\n        <Three>Three</Three>\n        <Three>Three</Three>\n        <One>One</One>\n    </Bar>    \n</Foo>";
    private MuleClient client;

    public ExpressionSplitterXPathWithFiltersTestCase() {
        XMLUnit.setIgnoreWhitespace((boolean)true);
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/routing/outbound/expression-splitter-xpath-with-filters-test.xml";
    }

    @Test
    public void testRecipientList() throws Exception {
        this.client = muleContext.getClient();
        this.client.dispatch("vm://distributor.queue", (Object)MESSAGE, null);
        this.readFromQueue("vm://service1.out", 2, "One");
        this.readFromQueue("vm://service2.out", 1, "Two");
        this.readFromQueue("vm://service3.out", 3, "Three");
    }

    public void readFromQueue(String name, int expectedNumber, String number) throws Exception {
        for (int i = 0; i < expectedNumber; ++i) {
            MuleMessage message = this.client.request(name, 2000L);
            Assert.assertNotNull((Object)message);
            Assert.assertThat((Object)XMLUnit.compareXML((String)("<" + number + ">" + number + "</" + number + ">"), (String)message.getPayloadAsString()).similar(), (Matcher)Is.is((Object)true));
        }
        Assert.assertNull((Object)this.client.request(name, 1000L));
    }
}

