/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing.outbound;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class ExpressionRecipientListSyncTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/routing/outbound/expression-recipient-list-sync-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/routing/outbound/expression-recipient-list-sync-test-flow.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW_EL, "org/mule/test/integration/routing/outbound/expression-recipient-list-sync-test-flow-el.xml"});
    }

    public ExpressionRecipientListSyncTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testRecipientList() throws Exception {
        String message = "test";
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, String> props = new HashMap<String, String>(3);
        props.put("recipient1", "vm://service1.queue?exchangePattern=request-response");
        props.put("recipient2", "vm://service2.queue?exchangePattern=request-response");
        props.put("recipient3", "vm://service3.queue?exchangePattern=request-response");
        MuleMessage result = client.send("vm://distributor.queue", (Object)message, props);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof MuleMessageCollection));
        MuleMessageCollection coll = (MuleMessageCollection)result;
        Assert.assertEquals((long)3L, (long)coll.size());
        MuleMessage[] results = coll.getMessagesAsArray();
        for (int i = 0; i < results.length; ++i) {
            MuleMessage muleMessage = results[i];
            Assert.assertEquals((Object)("test " + (i + 1) + " Received"), (Object)muleMessage.getPayload());
        }
    }
}

