/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing.outbound;

import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.processor.MessageProcessorChain;
import org.mule.api.routing.RoutePathNotFoundException;
import org.mule.api.routing.filter.Filter;
import org.mule.construct.Flow;
import org.mule.routing.ChoiceRouter;
import org.mule.routing.MessageProcessorFilterPair;
import org.mule.routing.filters.ExpressionFilter;
import org.mule.routing.filters.RegExFilter;
import org.mule.tck.junit4.FunctionalTestCase;

public class ChoiceRouterTestCase
extends FunctionalTestCase {
    private static final String WITH_DEFAULT_ROUTE_CHANNEL = "vm://with-default-route.in";
    private static final String WITHOUT_DEFAULT_ROUTE_CHANNEL = "vm://without-default-route.in";

    public ChoiceRouterTestCase() {
        this.setDisposeContextPerClass(true);
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/routing/outbound/choice-router-test.xml";
    }

    @Test
    public void filterReferenceShouldCreateFilterWithRegexFilterAndOutboundEndpointChain() {
        ChoiceRouter router = this.findChoiceRouterInFlow("without-default-route");
        MessageProcessorFilterPair pair = (MessageProcessorFilterPair)router.getConditionalMessageProcessors().get(0);
        this.assertIsRegExFilterWithPattern(pair.getFilter(), "apple");
        this.assertMessageChainIsOutboundEndpoint(pair.getMessageProcessor(), "vm://fruit-channel.in");
    }

    @Test
    public void embeddedFilterShouldCreatePairWithFilterAndOtherConfiguredMPsAsChain() {
        ChoiceRouter router = this.findChoiceRouterInFlow("with-default-route");
        MessageProcessorFilterPair firstPair = (MessageProcessorFilterPair)router.getConditionalMessageProcessors().get(0);
        this.assertIsRegExFilterWithPattern(firstPair.getFilter(), "apple");
        this.assertMessageChainIsOutboundEndpoint(firstPair.getMessageProcessor(), "vm://fruit-channel.in");
        MessageProcessorFilterPair secondPair = (MessageProcessorFilterPair)router.getConditionalMessageProcessors().get(1);
        this.assertIsRegExFilterWithPattern(secondPair.getFilter(), "turnip");
        this.assertMessageChainIsOutboundEndpoint(secondPair.getMessageProcessor(), "vm://veggie-channel.in");
        MessageProcessorFilterPair thirdPair = (MessageProcessorFilterPair)router.getConditionalMessageProcessors().get(2);
        this.assertIsExpressionFilterWithExpressionAndEvaluator(thirdPair.getFilter(), ".*berry", "regex");
        this.assertMessageChainIsOutboundEndpoint(thirdPair.getMessageProcessor(), "vm://fruit-channel.in");
    }

    @Test
    public void sendToInvalidRouteWithoutDefaultRouteShouldThrowException() throws Exception {
        MuleMessage result = muleContext.getClient().send(WITHOUT_DEFAULT_ROUTE_CHANNEL, (Object)"bad", null);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((String)"should have got a MuleException", (Object)result.getExceptionPayload());
        Assert.assertNotNull((Object)(result.getExceptionPayload().getException() instanceof MuleException));
        Assert.assertNotNull((Object)(result.getExceptionPayload().getRootException() instanceof RoutePathNotFoundException));
    }

    @Test
    public void sendToValidRouteShouldReturnValidResult() throws Exception {
        MuleMessage result = muleContext.getClient().send(WITHOUT_DEFAULT_ROUTE_CHANNEL, (Object)"apple", null);
        Assert.assertEquals((Object)"apple:fruit:fruit", (Object)result.getPayloadAsString());
    }

    @Test
    public void sendToAppleRouteShouldHitFruitService() throws Exception {
        MuleMessage result = muleContext.getClient().send(WITH_DEFAULT_ROUTE_CHANNEL, (Object)"apple", null);
        Assert.assertEquals((Object)"apple:fruit:fruit", (Object)result.getPayloadAsString());
    }

    @Test
    public void sendToTurnipRouteShouldHitVeggieService() throws Exception {
        MuleMessage result = muleContext.getClient().send(WITH_DEFAULT_ROUTE_CHANNEL, (Object)"turnip", null);
        Assert.assertEquals((Object)"turnip:veggie:veggie", (Object)result.getPayloadAsString());
    }

    @Test
    public void sendToBlueberryRouteShouldHitFruitService() throws Exception {
        MuleMessage result = muleContext.getClient().send(WITH_DEFAULT_ROUTE_CHANNEL, (Object)"blueberry", null);
        Assert.assertEquals((Object)"blueberry:fruit:fruit", (Object)result.getPayloadAsString());
    }

    @Test
    public void sendToInvalidRouteShouldHitDefaultRoute() throws Exception {
        MuleMessage result = muleContext.getClient().send(WITH_DEFAULT_ROUTE_CHANNEL, (Object)"car", null);
        Assert.assertEquals((Object)"car:default:default", (Object)result.getPayloadAsString());
    }

    private ChoiceRouter findChoiceRouterInFlow(String flowName) {
        Flow flow = this.lookupFlow(flowName);
        return this.getChoiceRouter(flow);
    }

    private Flow lookupFlow(String flowConstructName) {
        FlowConstruct flow = muleContext.getRegistry().lookupFlowConstruct(flowConstructName);
        Assert.assertNotNull((Object)flow);
        Assert.assertTrue((boolean)(flow instanceof Flow));
        return (Flow)flow;
    }

    private ChoiceRouter getChoiceRouter(Flow flowConstruct) {
        MessageProcessor routerMessageProcessor = (MessageProcessor)flowConstruct.getMessageProcessors().get(0);
        Assert.assertTrue((boolean)(routerMessageProcessor instanceof ChoiceRouter));
        return (ChoiceRouter)routerMessageProcessor;
    }

    private void assertIsRegExFilterWithPattern(Filter filter, String pattern) {
        Assert.assertTrue((boolean)(filter instanceof RegExFilter));
        RegExFilter regExFilter = (RegExFilter)filter;
        Assert.assertEquals((Object)regExFilter.getPattern(), (Object)pattern);
    }

    private void assertIsExpressionFilterWithExpressionAndEvaluator(Filter filter, String expression, String evaluator) {
        Assert.assertTrue((boolean)(filter instanceof ExpressionFilter));
        ExpressionFilter expressionFilter = (ExpressionFilter)filter;
        Assert.assertEquals((Object)expression, (Object)expressionFilter.getExpression());
        Assert.assertEquals((Object)evaluator, (Object)expressionFilter.getEvaluator());
    }

    private void assertMessageChainIsOutboundEndpoint(MessageProcessor processor, String expectedAddress) {
        Assert.assertTrue((boolean)(processor instanceof MessageProcessorChain));
        MessageProcessorChain chain = (MessageProcessorChain)processor;
        MessageProcessor firstInChain = (MessageProcessor)chain.getMessageProcessors().get(0);
        Assert.assertTrue((boolean)(firstInChain instanceof OutboundEndpoint));
        OutboundEndpoint endpoint = (OutboundEndpoint)firstInChain;
        String address = endpoint.getAddress();
        Assert.assertEquals((Object)expectedAddress, (Object)address);
    }
}

