/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing.nested;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.config.i18n.MessageFactory;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class BindingExceptionOnInterfaceMethodTestCase
extends AbstractServiceAndFlowTestCase {
    private static final String PREFIX = "Exception in service component: ";

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/routing/nested/binding-exception-on-interface-method-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/routing/nested/binding-exception-on-interface-method-flow.xml"});
    }

    public BindingExceptionOnInterfaceMethodTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testExceptionOnBinding() throws Exception {
        MuleMessage reply = muleContext.getClient().send("vm://invoker.in", (Object)"Test Message", null);
        Assert.assertNotNull((Object)reply);
        String payload = reply.getPayloadAsString();
        Assert.assertTrue((boolean)payload.contains("MuleRuntimeException"));
        Assert.assertTrue((boolean)payload.contains(PREFIX));
    }

    public static interface BindigInterface {
        public String process(String var1, Integer var2) throws MuleRuntimeException;
    }

    public static class ExceptionThrowingService {
        public String process(String s, Integer v) {
            throw new MuleRuntimeException(MessageFactory.createStaticMessage((String)"Boom"));
        }
    }

    public static class Component {
        private BindigInterface binding;

        public String invoke(String payload) {
            try {
                this.binding.process(payload, 49374);
            }
            catch (MuleRuntimeException muleException) {
                return BindingExceptionOnInterfaceMethodTestCase.PREFIX + muleException.toString();
            }
            return "ERROR, should not have come here";
        }

        public BindigInterface getBinding() {
            return this.binding;
        }

        public void setBinding(BindigInterface binding) {
            this.binding = binding;
        }
    }
}

