/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.api.MuleEventContext;
import org.mule.api.routing.RoutingException;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.junit4.FunctionalTestCase;

@RunWith(value=Parameterized.class)
public class UntilSuccessfulStreamCloserTestCase
extends FunctionalTestCase {
    @Rule
    public ExpectedException expectedException;
    private static final InputStream firstInputStream = (InputStream)Mockito.mock(InputStream.class);
    private static final InputStream secondInputStream = (InputStream)Mockito.mock(InputStream.class);
    private static final InputStream thirdInputStream = (InputStream)Mockito.mock(InputStream.class);
    private static final InputStream[] streams = new InputStream[]{firstInputStream, secondInputStream, thirdInputStream};
    private static CountDownLatch latch;
    private static int i;
    private String flowPrefix;

    public UntilSuccessfulStreamCloserTestCase(String flowPrefix, ExpectedException expectedException) {
        this.flowPrefix = flowPrefix;
        this.expectedException = expectedException;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"asynchronous", ExpectedException.none()}, {"synchronous", UntilSuccessfulStreamCloserTestCase.getExpectedRoutingException()});
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/routing/until-successful-stream-closer-config.xml";
    }

    @Before
    public void setUp() {
        Mockito.reset((Object[])new InputStream[]{firstInputStream, secondInputStream, thirdInputStream});
        latch = new CountDownLatch(streams.length);
    }

    @Test
    public void retryPayloadsAreClosed() throws Exception {
        this.runFlow(this.flowPrefix + "UntilSuccessfulStreamCloser");
        MatcherAssert.assertThat((String)"The failure processor was not executed.", (Object)latch.await(10000L, TimeUnit.MILLISECONDS), (Matcher)Is.is((Object)true));
        for (InputStream stream : streams) {
            ((InputStream)Mockito.verify((Object)stream)).close();
        }
    }

    private static ExpectedException getExpectedRoutingException() {
        ExpectedException routingExpectedException = ExpectedException.none();
        routingExpectedException.expect(RoutingException.class);
        return routingExpectedException;
    }

    static {
        i = 0;
    }

    public static class PayloadSetter
    implements EventCallback {
        public void eventReceived(MuleEventContext context, Object component) throws Exception {
            context.getMessage().setPayload((Object)streams[i++]);
            latch.countDown();
            throw new RuntimeException("Failure exception");
        }
    }
}

