/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.processor.MessageProcessor;
import org.mule.message.DefaultExceptionPayload;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.concurrent.Latch;

public class UntilSuccessfulExceptionStrategyTestCase
extends FunctionalTestCase {
    private static final int TIMEOUT = 10;
    private static Latch latch;

    @Before
    public void setUp() {
        latch = new Latch();
    }

    protected String getConfigFile() {
        return "org/mule/test/integration/routing/until-successful-exception-strategy-config.xml";
    }

    @Test
    public void usingSimpleSetUp() throws Exception {
        this.testHandlingOfFailures("vm://simple");
    }

    @Test
    public void usingSimpleSetUpAndNoRetries() throws Exception {
        this.testHandlingOfFailures("vm://noRetries");
    }

    @Test
    public void usingSplitterAggregator() throws Exception {
        this.testHandlingOfFailures("vm://splitter");
    }

    @Test
    public void usingSplitterAggregatorAndNoRetries() throws Exception {
        this.testHandlingOfFailures("vm://noRetriesSplitter");
    }

    private void testHandlingOfFailures(String entryPoint) throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send(entryPoint, this.getTestMuleMessage());
        Assert.assertThat((Object)response.getExceptionPayload(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)response.getPayloadAsString(), (Matcher)Matchers.is((Object)"ok"));
    }

    public static class WaitOnceBeforeUnlockProcessor
    extends UnlockProcessor {
        public WaitOnceBeforeUnlockProcessor() {
            this.count = new AtomicInteger(1);
        }
    }

    public static class WaitTwiceBeforeUnlockProcessor
    extends UnlockProcessor {
        public WaitTwiceBeforeUnlockProcessor() {
            this.count = new AtomicInteger(2);
        }
    }

    public static class UnlockProcessor
    implements MessageProcessor {
        AtomicInteger count;

        public MuleEvent process(MuleEvent event) throws MuleException {
            if (this.count.decrementAndGet() == 0) {
                latch.release();
            }
            return event;
        }
    }

    public static class LockProcessor
    implements MessageProcessor {
        public MuleEvent process(MuleEvent event) throws MuleException {
            try {
                if (!latch.await(10L, TimeUnit.SECONDS)) {
                    event.getMessage().setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)new RuntimeException()));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return event;
        }
    }
}

