/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.context.notification.RoutingNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.RoutingNotification;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class InboundAggregationWithTimeoutTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/routing/multi-inbound-aggregator-with-timeout-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/routing/multi-inbound-aggregator-with-timeout-flow.xml"});
    }

    public InboundAggregationWithTimeoutTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testAggregatorTimeout() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        muleContext.registerListener((ServerNotificationListener)new RoutingNotificationListener<RoutingNotification>(){

            public void onNotification(RoutingNotification notification) {
                if (notification.getAction() == 1303) {
                    latch.countDown();
                }
            }
        });
        String message = "test";
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://distributor.queue", (Object)message, null);
        Assert.assertTrue((boolean)latch.await(5000L, TimeUnit.MILLISECONDS));
    }
}

