/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleMessage;
import org.mule.api.MuleMessageCollection;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.lifecycle.Callable;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class InboundAggregationNoTimeoutTestCase
extends AbstractServiceAndFlowTestCase {
    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "org/mule/test/integration/routing/multi-inbound-aggregator-no-timeout-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "org/mule/test/integration/routing/multi-inbound-aggregator-no-timeout-flow.xml"});
    }

    public InboundAggregationNoTimeoutTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Test
    public void testAggregatorWithNoTimeout() throws Exception {
        MuleMessage message = this.getTestMuleMessage();
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://distributor.queue", message);
        MuleMessage result = client.request("vm://results", 10000L);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)(result instanceof MuleMessageCollection));
        MuleMessageCollection mc = (MuleMessageCollection)result;
        Assert.assertEquals((long)3L, (long)mc.size());
        for (int i = 0; i < mc.getMessagesAsArray().length; ++i) {
            MuleMessage msg = mc.getMessagesAsArray()[i];
            Assert.assertEquals((Object)"test Received", (Object)msg.getPayload());
            Assert.assertEquals((Object)message.getMessageRootId(), (Object)msg.getMessageRootId());
        }
        Assert.assertEquals((Object)message.getMessageRootId(), (Object)result.getMessageRootId());
    }

    public static class TestCollectionService
    implements Callable {
        public Object onCall(MuleEventContext eventContext) throws Exception {
            MuleMessage message = eventContext.getMessage();
            this.process((List)message.getPayload());
            return message;
        }

        public Object process(List<?> responseMessages) {
            Assert.assertEquals((long)3L, (long)responseMessages.size());
            return responseMessages;
        }
    }
}

