/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.routing;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.context.notification.RoutingNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.RoutingNotification;
import org.mule.routing.correlation.CorrelationTimeoutException;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.util.ExceptionUtils;

public class AsyncReplyTimeoutFailTestCase
extends FunctionalTestCase {
    private CountDownLatch latch;

    protected String getConfigFile() {
        return "org/mule/test/integration/routing/multi-async-repy-timeout-fail.xml";
    }

    @Test
    public void testAggregatorTimeoutWithFailure() throws Exception {
        this.latch = new CountDownLatch(1);
        muleContext.registerListener((ServerNotificationListener)new RoutingNotificationListener<RoutingNotification>(){

            public void onNotification(RoutingNotification notification) {
                if (notification.getAction() == 1303) {
                    AsyncReplyTimeoutFailTestCase.this.latch.countDown();
                }
            }
        });
        String message = "test";
        try {
            muleContext.getClient().send("vm://distributor.queue", (Object)message, null);
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(ExceptionUtils.getRootCause((Throwable)e) instanceof CorrelationTimeoutException));
        }
        Assert.assertTrue((boolean)this.latch.await(3000L, TimeUnit.MILLISECONDS));
    }
}

